/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.converter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import mcedu.converter.converter.PlayerFile;
import mcedu.converter.converter.RegionAnvil;
import mcedu.converter.converter.RegionOld;
import mcedu.converter.converter.SubRegion;

public class Converter {
    private File baseFolder;
    private ArrayList<SubRegion> regionFiles;

    public Converter(File path) {
        this.baseFolder = path;
        try {
            this.regionFiles = this.getRegionFiles();
            this.getDatFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void convert(HashMap<Integer, Integer> translations) {
        if (this.regionFiles == null) {
            return;
        }
        for (SubRegion r : this.regionFiles) {
            try {
                r.convert(translations);
            }
            catch (Exception e) {}
        }
    }

    private ArrayList<SubRegion> getRegionFiles() {
        File regionDir = new File(this.baseFolder, "region");
        if (!regionDir.exists()) {
            regionDir = new File(this.baseFolder, "DIM1/region");
        }
        if (!regionDir.exists()) {
            regionDir = new File(this.baseFolder, "DIM-1/region");
        }
        FileFilter mcaFiles = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith("mca");
            }
        };
        FileFilter mcrFiles = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith("mcr");
            }
        };
        boolean anvil = true;
        File[] files = regionDir.listFiles(mcaFiles);
        if (files == null || files.length == 0) {
            anvil = false;
            files = regionDir.listFiles(mcrFiles);
            if (files == null) {
                return null;
            }
        }
        ArrayList<SubRegion> result = new ArrayList<SubRegion>();
        if (anvil) {
            for (int i = 0; i < files.length; ++i) {
                result.add(new RegionAnvil(files[i]));
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                result.add(new RegionOld(files[i]));
            }
        }
        return result;
    }

    private ArrayList<PlayerFile> getDatFiles() {
        try {
            File[] files;
            File playersDir = new File(this.baseFolder, "players");
            File levelDat = new File(this.baseFolder, "level.dat");
            FileFilter datFiles = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith("dat");
                }
            };
            ArrayList<PlayerFile> result = new ArrayList<PlayerFile>();
            if (playersDir.exists() && (files = playersDir.listFiles(datFiles)) != null) {
                for (int i = 0; i < files.length; ++i) {
                    result.add(new PlayerFile(files[i], "rw"));
                }
            }
            if (levelDat.exists()) {
                result.add(new PlayerFile(levelDat, "rw"));
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

