/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.com.mojang.nbt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mcedu.converter.com.mojang.nbt.CompoundTag;
import mcedu.converter.com.mojang.nbt.Tag;

public class NbtIo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTag readCompressed(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(in)));
        try {
            CompoundTag compoundTag = NbtIo.read(dis);
            return compoundTag;
        }
        finally {
            dis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompressed(CompoundTag tag, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(out));
        try {
            NbtIo.write(tag, dos);
        }
        finally {
            dos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTag decompress(byte[] buffer) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(buffer))));
        try {
            CompoundTag compoundTag = NbtIo.read(dis);
            return compoundTag;
        }
        finally {
            dis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(CompoundTag tag) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(baos));
        try {
            NbtIo.write(tag, dos);
        }
        finally {
            dos.close();
        }
        return baos.toByteArray();
    }

    public static void safeWrite(CompoundTag tag, File file) throws IOException {
        File file2 = new File(file.getAbsolutePath() + "_tmp");
        if (file2.exists()) {
            file2.delete();
        }
        NbtIo.write(tag, file2);
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            throw new IOException("Failed to delete " + file);
        }
        file2.renameTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(CompoundTag tag, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        try {
            NbtIo.write(tag, dos);
        }
        finally {
            dos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTag read(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        try {
            CompoundTag compoundTag = NbtIo.read(dis);
            return compoundTag;
        }
        finally {
            dis.close();
        }
    }

    public static CompoundTag read(DataInput dis) throws IOException {
        Tag tag = Tag.readNamedTag(dis);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(CompoundTag tag, DataOutput dos) throws IOException {
        Tag.writeNamedTag(tag, dos);
    }
}

