/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.com.mojang.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import mcedu.converter.com.mojang.nbt.Tag;

public class ListTag<T extends Tag>
extends Tag {
    private List<T> list = new ArrayList<T>();
    private byte type;

    public ListTag() {
        super("");
    }

    public ListTag(String name) {
        super(name);
    }

    @Override
    void write(DataOutput dos) throws IOException {
        this.type = this.list.size() > 0 ? ((Tag)this.list.get(0)).getId() : (byte)1;
        dos.writeByte(this.type);
        dos.writeInt(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            ((Tag)this.list.get(i)).write(dos);
        }
    }

    @Override
    void load(DataInput dis) throws IOException {
        this.type = dis.readByte();
        int size = dis.readInt();
        this.list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            Tag tag = Tag.newTag(this.type, null);
            tag.load(dis);
            this.list.add(tag);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public String toString() {
        return "" + this.list.size() + " entries of type " + Tag.getTagName(this.type);
    }

    @Override
    public void print(String prefix, PrintStream out) {
        super.print(prefix, out);
        out.println(prefix + "{");
        String orgPrefix = prefix;
        prefix = prefix + "   ";
        for (int i = 0; i < this.list.size(); ++i) {
            ((Tag)this.list.get(i)).print(prefix, out);
        }
        out.println(orgPrefix + "}");
    }

    public void add(T tag) {
        this.type = ((Tag)tag).getId();
        this.list.add(tag);
    }

    public T get(int index) {
        return (T)((Tag)this.list.get(index));
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Tag copy() {
        ListTag<T> res = new ListTag<T>(this.getName());
        res.type = this.type;
        for (Tag t2 : this.list) {
            Tag copy = t2.copy();
            res.list.add(copy);
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ListTag o = (ListTag)obj;
            if (this.type == o.type) {
                return ((Object)this.list).equals(o.list);
            }
        }
        return false;
    }

    @Override
    public Tag findChildByName(String name, boolean recursive) {
        if (this.list != null) {
            for (Tag t2 : this.list) {
                Tag result;
                if (t2.getName() != null) {
                    if (t2.getName().equals("Sections")) {
                        System.out.println("here");
                    }
                    if (t2.getName().equals(name)) {
                        return t2;
                    }
                }
                if (!recursive || (result = t2.findChildByName(name, true)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void findAllChildrenByName(ArrayList<Tag> result, String name, boolean recursive) {
        if (result == null) {
            result = new ArrayList();
        }
        if (this.list != null) {
            for (Tag t2 : this.list) {
                if (t2.getName() != null && t2.getName().equals(name)) {
                    result.add(t2);
                }
                if (!recursive) continue;
                t2.findAllChildrenByName(result, name, true);
            }
        }
    }
}

