/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.com.mojang.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mcedu.converter.com.mojang.nbt.Tag;

public class IntArrayTag
extends Tag {
    public int[] data;

    public IntArrayTag(String name) {
        super(name);
    }

    public IntArrayTag(String name, int[] data) {
        super(name);
        this.data = data;
    }

    @Override
    void write(DataOutput dos) throws IOException {
        dos.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            dos.writeInt(this.data[i]);
        }
    }

    @Override
    void load(DataInput dis) throws IOException {
        int length = dis.readInt();
        this.data = new int[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = dis.readInt();
        }
    }

    @Override
    public byte getId() {
        return 11;
    }

    @Override
    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            IntArrayTag o = (IntArrayTag)obj;
            return this.data == null && o.data == null || this.data != null && this.data.equals(o.data);
        }
        return false;
    }

    @Override
    public Tag copy() {
        int[] cp = new int[this.data.length];
        System.arraycopy(this.data, 0, cp, 0, this.data.length);
        return new IntArrayTag(this.getName(), cp);
    }
}

