/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.com.mojang.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mcedu.converter.com.mojang.nbt.ByteArrayTag;
import mcedu.converter.com.mojang.nbt.ByteTag;
import mcedu.converter.com.mojang.nbt.DoubleTag;
import mcedu.converter.com.mojang.nbt.FloatTag;
import mcedu.converter.com.mojang.nbt.IntArrayTag;
import mcedu.converter.com.mojang.nbt.IntTag;
import mcedu.converter.com.mojang.nbt.ListTag;
import mcedu.converter.com.mojang.nbt.LongTag;
import mcedu.converter.com.mojang.nbt.ShortTag;
import mcedu.converter.com.mojang.nbt.StringTag;
import mcedu.converter.com.mojang.nbt.Tag;

public class CompoundTag
extends Tag {
    private Map<String, Tag> tags = new HashMap<String, Tag>();

    public CompoundTag() {
        super("");
    }

    public CompoundTag(String name) {
        super(name);
    }

    @Override
    void write(DataOutput dos) throws IOException {
        for (Tag tag : this.tags.values()) {
            Tag.writeNamedTag(tag, dos);
        }
        dos.writeByte(0);
    }

    @Override
    void load(DataInput dis) throws IOException {
        Tag tag;
        this.tags.clear();
        while ((tag = Tag.readNamedTag(dis)).getId() != 0) {
            this.tags.put(tag.getName(), tag);
        }
    }

    public Collection<Tag> getAllTags() {
        return this.tags.values();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public void put(String name, Tag tag) {
        this.tags.put(name, tag.setName(name));
    }

    public void putByte(String name, byte value) {
        this.tags.put(name, new ByteTag(name, value));
    }

    public void putShort(String name, short value) {
        this.tags.put(name, new ShortTag(name, value));
    }

    public void putInt(String name, int value) {
        this.tags.put(name, new IntTag(name, value));
    }

    public void putLong(String name, long value) {
        this.tags.put(name, new LongTag(name, value));
    }

    public void putFloat(String name, float value) {
        this.tags.put(name, new FloatTag(name, value));
    }

    public void putDouble(String name, double value) {
        this.tags.put(name, new DoubleTag(name, value));
    }

    public void putString(String name, String value) {
        this.tags.put(name, new StringTag(name, value));
    }

    public void putByteArray(String name, byte[] value) {
        this.tags.put(name, new ByteArrayTag(name, value));
    }

    public void putIntArray(String name, int[] value) {
        this.tags.put(name, new IntArrayTag(name, value));
    }

    public void putCompound(String name, CompoundTag value) {
        this.tags.put(name, value.setName(name));
    }

    public void putBoolean(String string, boolean val) {
        this.putByte(string, val ? (byte)1 : 0);
    }

    public Tag get(String name) {
        return this.tags.get(name);
    }

    public boolean contains(String name) {
        return this.tags.containsKey(name);
    }

    public byte getByte(String name) {
        if (!this.tags.containsKey(name)) {
            return 0;
        }
        return ((ByteTag)this.tags.get((Object)name)).data;
    }

    public short getShort(String name) {
        if (!this.tags.containsKey(name)) {
            return 0;
        }
        return ((ShortTag)this.tags.get((Object)name)).data;
    }

    public int getInt(String name) {
        if (!this.tags.containsKey(name)) {
            return 0;
        }
        return ((IntTag)this.tags.get((Object)name)).data;
    }

    public long getLong(String name) {
        if (!this.tags.containsKey(name)) {
            return 0L;
        }
        return ((LongTag)this.tags.get((Object)name)).data;
    }

    public float getFloat(String name) {
        if (!this.tags.containsKey(name)) {
            return 0.0f;
        }
        return ((FloatTag)this.tags.get((Object)name)).data;
    }

    public double getDouble(String name) {
        if (!this.tags.containsKey(name)) {
            return 0.0;
        }
        return ((DoubleTag)this.tags.get((Object)name)).data;
    }

    public String getString(String name) {
        if (!this.tags.containsKey(name)) {
            return "";
        }
        return ((StringTag)this.tags.get((Object)name)).data;
    }

    public byte[] getByteArray(String name) {
        if (!this.tags.containsKey(name)) {
            return new byte[0];
        }
        return ((ByteArrayTag)this.tags.get((Object)name)).data;
    }

    public int[] getIntArray(String name) {
        if (!this.tags.containsKey(name)) {
            return new int[0];
        }
        return ((IntArrayTag)this.tags.get((Object)name)).data;
    }

    public CompoundTag getCompound(String name) {
        if (!this.tags.containsKey(name)) {
            return new CompoundTag(name);
        }
        return (CompoundTag)this.tags.get(name);
    }

    public ListTag<? extends Tag> getList(String name) {
        if (!this.tags.containsKey(name)) {
            return new ListTag(name);
        }
        return (ListTag)this.tags.get(name);
    }

    public boolean getBoolean(String string) {
        return this.getByte(string) != 0;
    }

    @Override
    public String toString() {
        return "" + this.tags.size() + " entries";
    }

    @Override
    public void print(String prefix, PrintStream out) {
        super.print(prefix, out);
        out.println(prefix + "{");
        String orgPrefix = prefix;
        prefix = prefix + "   ";
        for (Tag tag : this.tags.values()) {
            tag.print(prefix, out);
        }
        out.println(orgPrefix + "}");
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    public Tag copy() {
        CompoundTag tag = new CompoundTag(this.getName());
        for (String key : this.tags.keySet()) {
            tag.put(key, this.tags.get(key).copy());
        }
        return tag;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            CompoundTag o = (CompoundTag)obj;
            return ((Object)this.tags.entrySet()).equals(o.tags.entrySet());
        }
        return false;
    }

    @Override
    public Tag findChildByName(String name, boolean recursive) {
        if (this.tags != null) {
            for (Tag t2 : this.tags.values()) {
                Tag result;
                if (t2.getName() != null && t2.getName().equals(name)) {
                    return t2;
                }
                if (!recursive || (result = t2.findChildByName(name, true)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void findAllChildrenByName(ArrayList<Tag> result, String name, boolean recursive) {
        if (result == null) {
            result = new ArrayList();
        }
        if (this.tags.values() != null) {
            for (Tag t2 : this.tags.values()) {
                if (t2.getName() != null && t2.getName().equals(name)) {
                    result.add(t2);
                }
                if (!recursive) continue;
                t2.findAllChildrenByName(result, name, true);
            }
        }
    }
}

