/*
 * Decompiled with CFR 0.152.
 */
package mcedu.converter.com.mojang.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mcedu.converter.com.mojang.nbt.Tag;

public class ByteArrayTag
extends Tag {
    public byte[] data;

    public ByteArrayTag(String name) {
        super(name);
    }

    public ByteArrayTag(String name, byte[] data) {
        super(name);
        this.data = data;
    }

    @Override
    void write(DataOutput dos) throws IOException {
        dos.writeInt(this.data.length);
        dos.write(this.data);
    }

    @Override
    void load(DataInput dis) throws IOException {
        int length = dis.readInt();
        this.data = new byte[length];
        dis.readFully(this.data);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ByteArrayTag o = (ByteArrayTag)obj;
            return this.data == null && o.data == null || this.data != null && this.data.equals(o.data);
        }
        return false;
    }

    @Override
    public Tag copy() {
        byte[] cp = new byte[this.data.length];
        System.arraycopy(this.data, 0, cp, 0, this.data.length);
        return new ByteArrayTag(this.getName(), cp);
    }
}

