/*
 * Decompiled with CFR 0.152.
 */
package mcedu.common;

import java.util.ArrayList;
import java.util.List;
import mcedu.common.EduUserStateEntry;

public class EduUserStates {
    private List<EduUserStateEntry> users = new ArrayList<EduUserStateEntry>();

    public EduUserStates() {
    }

    public EduUserStates(String data) {
        this.getDataFromString(data);
    }

    public void addUserToList(EduUserStateEntry userState) {
        this.users.add(userState);
    }

    public void removeUserFromList(String username) {
        EduUserStateEntry entryToBeRemoved = null;
        for (EduUserStateEntry entry : this.users) {
            if (!entry.getUsername().equals(username)) continue;
            entryToBeRemoved = entry;
            break;
        }
        if (entryToBeRemoved != null) {
            this.users.remove(entryToBeRemoved);
        }
    }

    public String getDataAsString() {
        String userData = "";
        for (EduUserStateEntry user : this.users) {
            userData = userData + user.getDataAsString() + "/";
        }
        return userData;
    }

    public void getDataFromString(String data) {
        String[] userData = data.split("/");
        for (int i = 0; i < userData.length; ++i) {
            try {
                if (userData[i] == null || userData[i].isEmpty()) continue;
                this.users.add(EduUserStateEntry.createUserFromString(userData[i]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public EduUserStateEntry getUserStatesWithName(String username) {
        for (EduUserStateEntry user : this.users) {
            if (!user.getUsername().equals(username)) continue;
            return user;
        }
        return null;
    }

    public List getUsers() {
        return this.users;
    }
}

