/*
 * Decompiled with CFR 0.152.
 */
package mcedu.common;

public class EduUserStateEntry {
    private String username;
    private boolean isAdmin;
    private boolean isMuted;
    private boolean isFreezed;
    private boolean isInBuildMode;
    private boolean isInCreativeMode;

    public EduUserStateEntry(String username, boolean isAdmin, boolean isMuted, boolean isFreezed, boolean isInBuildMode, boolean isInCreativeMode) {
        this.username = username;
        this.isAdmin = isAdmin;
        this.isMuted = isMuted;
        this.isFreezed = isFreezed;
        this.isInBuildMode = isInBuildMode;
        this.isInCreativeMode = isInCreativeMode;
    }

    public String getDataAsString() {
        String flags = "";
        if (this.isAdmin) {
            flags = flags + "a";
        }
        if (this.isMuted) {
            flags = flags + "m";
        }
        if (this.isFreezed) {
            flags = flags + "f";
        }
        if (this.isInBuildMode) {
            flags = flags + "b";
        }
        if (this.isInCreativeMode) {
            flags = flags + "c";
        }
        return this.username + "|" + flags;
    }

    public static EduUserStateEntry createUserFromString(String user) throws Exception {
        String flags = "";
        try {
            flags = user.split("\\|")[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new EduUserStateEntry(user.split("\\|")[0], flags.contains("a"), flags.contains("m"), flags.contains("f"), flags.contains("b"), flags.contains("c"));
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public boolean isFreezed() {
        return this.isFreezed;
    }

    public boolean isInBuildMode() {
        return this.isInBuildMode;
    }

    public boolean isInCreativeMode() {
        return this.isInCreativeMode;
    }
}

