/*
 * Decompiled with CFR 0.152.
 */
package mcedu.common;

import java.io.IOException;
import mcedu.client.EduClientSettings;
import mcedu.global.Version;
import mcedu.global.tools.Security;
import mcedu.server.EduServerTemp;

public class EduLoginData {
    public String hostingToken;
    public String playerSkin;
    public String playerAlias;
    public String playerOriginalUsername;
    public boolean isAdmin;
    public String encryptedServerPassword;
    public boolean customSkinFromURL;
    public int eduProtocolVersion;
    public String encryptedAliasPassword;
    public boolean doNotPasswordProtectAlias;
    public String minecrafteduVersion;
    public String minecrafteduBuild;
    public String minecrafteduBuildDate;
    public boolean weirdClientLoginData = false;

    public EduLoginData(int eduProtocolVersion, String playerSkin, String playerAlias, String playerOriginalUserName, boolean isAdmin, String serverPassword, boolean customSkinFromURL, String encryptedAliasPassword, boolean doNotPasswordProtectAlias) {
        this.eduProtocolVersion = eduProtocolVersion;
        this.playerSkin = playerSkin;
        this.playerAlias = playerAlias;
        this.playerOriginalUsername = playerOriginalUserName;
        this.isAdmin = isAdmin;
        this.encryptedServerPassword = Security.getMd5(serverPassword);
        this.customSkinFromURL = customSkinFromURL;
        this.encryptedAliasPassword = encryptedAliasPassword;
        this.doNotPasswordProtectAlias = doNotPasswordProtectAlias;
    }

    public EduLoginData(et packetBuffer) {
        this.readDataFromClient(packetBuffer);
        try {
            EduServerTemp.getS().setPlayerLastLoginData(this.playerOriginalUsername, this);
        }
        catch (Exception e) {
            this.weirdClientLoginData = true;
            e.printStackTrace();
        }
    }

    private void readDataFromClient(et packetBuffer) {
        this.weirdClientLoginData = false;
        try {
            this.hostingToken = this.readString(packetBuffer, 400);
            this.minecrafteduVersion = this.readString(packetBuffer, 20);
            this.minecrafteduBuild = this.readString(packetBuffer, 20);
            this.minecrafteduBuildDate = this.readString(packetBuffer, 50);
            this.eduProtocolVersion = packetBuffer.readInt();
            this.playerSkin = this.readString(packetBuffer, 100);
            this.playerAlias = this.readString(packetBuffer, 20);
            this.playerOriginalUsername = this.readString(packetBuffer, 100);
            this.isAdmin = packetBuffer.readBoolean();
            this.encryptedServerPassword = this.readString(packetBuffer, 100);
            this.customSkinFromURL = packetBuffer.readBoolean();
            this.encryptedAliasPassword = this.readString(packetBuffer, 100);
            this.doNotPasswordProtectAlias = packetBuffer.readBoolean();
        }
        catch (Exception e) {
            this.weirdClientLoginData = true;
        }
    }

    public void writeDataToServer(et packetBuffer) throws IOException {
        this.writeString(EduClientSettings.getS().getPassableHostingToken(), packetBuffer);
        this.writeString(Double.toString(Version.getVersion()), packetBuffer);
        this.writeString(Integer.toString(Version.getBuildNumber()), packetBuffer);
        this.writeString(Version.getReleaseDate(), packetBuffer);
        packetBuffer.writeInt(this.eduProtocolVersion);
        this.writeString(this.playerSkin, packetBuffer);
        this.writeString(this.playerAlias, packetBuffer);
        this.writeString(this.playerOriginalUsername, packetBuffer);
        packetBuffer.writeBoolean(this.isAdmin);
        this.writeString(this.encryptedServerPassword, packetBuffer);
        packetBuffer.writeBoolean(this.customSkinFromURL);
        this.writeString(this.encryptedAliasPassword, packetBuffer);
        packetBuffer.writeBoolean(this.doNotPasswordProtectAlias);
    }

    private void writeString(String string, et packetBuffer) throws IOException {
        packetBuffer.a(string);
    }

    public String readString(et packetBuffer, int stringLength) throws IOException {
        return packetBuffer.c(stringLength);
    }
}

