/*
 * Decompiled with CFR 0.152.
 */
package mcedu.client;

import java.io.File;
import java.util.HashMap;
import mcedu.global.tools.AbstractSettingsHandler;

public class EduClientSettingsHandler
extends AbstractSettingsHandler {
    public EduClientSettingsHandler(File pathToSettingsFile, String missingSettingDefaultValue) {
        super(pathToSettingsFile, missingSettingDefaultValue);
    }

    @Override
    public HashMap<String, String> getDefaultSettings() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("disable-sp", "false");
        map.put("use-custom-skin", "false");
        map.put("customsavefolder", "");
        map.put("disable-startmenu", "false");
        map.put("showstats", "false");
        map.put("showachievements", "false");
        map.put("visualfill", "true");
        map.put("advancedbuildmode", "false");
        map.put("allow-server-texturepacks", "true");
        map.put("tooltips", "true");
        map.put("custom-screenshots-folder", "");
        map.put("lang", "en_US");
        return map;
    }

    @Override
    public HashMap<String, String> getSettingComments() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("disable-sp", "Set to true to remove the singleplayer button from main menu. Default: false");
        map.put("use-custom-skin", "Set to true to use your own custom Mojang skin in game. Requires you to use login mode 'Mojang Account' and login. Default: false");
        map.put("customsavefolder", "Set a path to to the custom folder for your singleplayer saves. Default: blank");
        map.put("disable-startmenu", "Set to true to hide the 'back to start menu' button from main menu. Default: false");
        map.put("showstats", "Set to true to show the 'statistics' button in the settings menu. Default: false");
        map.put("showachievements", "Set to true to show achievements and the achievements button in the settings menu. Default: false");
        map.put("visualfill", "Set to false to disable the visual aid for building modes. Default: true");
        map.put("advancedbuildmode", "Set to true to use advanced build mode. Default: false");
        map.put("allow-server-texturepacks", "Set to false to prevent downloading and utilize texture packs if MinecraftEdu Server has one set in it's world. Default: true");
        map.put("tooltips", "Set to false to hide tooltips for some settings to explain what they are. Default: true");
        map.put("lang", "Language for MinecraftEdu functionality in the client. Generated by MinecraftEdu Applications, should not be changed by hand. Default: en_US");
        return map;
    }

    @Override
    public String getFileComment() {
        return this.getFormattedComment("This file contains the MinecraftEdu Client settings. Some of these settings can be configured using the MinecraftEdu Settings menu in the Client Settings Menu.");
    }

    @Override
    public String getFormattedComment(String comment) {
        return "# " + comment;
    }

    @Override
    public String getCommentStartFormat() {
        return "# ";
    }

    public boolean getSingleplayerDisabled() {
        return this.getValueForSettingAsBoolean("disable-sp", false);
    }

    public boolean getUseCustomSkin() {
        return this.getValueForSettingAsBoolean("use-custom-skin", false);
    }

    public String getCustomSPSaveFolder() {
        String path = this.getValueForSetting("customsavefolder");
        if (path != null && new File(path).exists() && new File(path).isDirectory()) {
            return path;
        }
        return "";
    }

    public boolean getDisableStartMenuButton() {
        return this.getValueForSettingAsBoolean("disable-startmenu", false);
    }

    public boolean getShowStats() {
        return this.getValueForSettingAsBoolean("showstats", false);
    }

    public boolean getShowAchievements() {
        return this.getValueForSettingAsBoolean("showachievements", false);
    }

    public boolean getVisualFillEnabled() {
        return this.getValueForSettingAsBoolean("visualfill", true);
    }

    public boolean getAdvancedBuildModeEnabled() {
        return this.getValueForSettingAsBoolean("advancedbuildmode", true);
    }

    public boolean getAllowServerTexturepacks() {
        return this.getValueForSettingAsBoolean("allow-server-texturepacks", true);
    }

    public boolean getTooltipsEnabled() {
        return this.getValueForSettingAsBoolean("tooltips", true);
    }

    public String getCustomScreenShotsFolder() {
        return this.getValueForSetting("custom-screenshots-folder");
    }

    public void setShowStats(boolean state) {
        this.saveSetting("showstats", Boolean.toString(state).toLowerCase());
    }

    public void setShowAchievements(boolean state) {
        this.saveSetting("showachievements", Boolean.toString(state).toLowerCase());
    }

    public void setVisualFillEnabled(boolean state) {
        this.saveSetting("visualfill", Boolean.toString(state).toLowerCase());
    }

    public void setAdvancedBuildModeEnabled(boolean state) {
        this.saveSetting("advancedbuildmode", Boolean.toString(state).toLowerCase());
    }

    public void setAllowServerTexturepacks(boolean state) {
        this.saveSetting("allow-server-texturepacks", Boolean.toString(state).toLowerCase());
    }

    public void setTooltipsEnabled(boolean state) {
        this.saveSetting("tooltips", Boolean.toString(state).toLowerCase());
    }

    public void setCustomScreenShotsFolder(String path) {
        this.saveSetting("custom-screenshots-folder", path);
    }
}

