/*
 * Decompiled with CFR 0.152.
 */
package mcedu.client;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import mcedu.client.EduAdminGui;
import mcedu.client.EduClientFunctions;
import mcedu.client.EduClientPaths;
import mcedu.client.EduClientPlayerBuildSettings;
import mcedu.client.EduClientPlayerSettings;
import mcedu.client.EduClientReconnectThread;
import mcedu.client.EduClientServerSettings;
import mcedu.client.EduClientSettingsHandler;
import mcedu.client.EduTranslationHelper;
import mcedu.global.Version;
import mcedu.global.tools.Datahandler;
import mcedu.hosting.EduHostingServer;
import mcedu.hosting.EduHostingUserCredentials;

public class EduClientSettings
extends EduClientPaths {
    public EduTranslationHelper edutranslationhelper = new EduTranslationHelper("/lang/", false, ".lang", " ", false);
    public boolean isAdmin = false;
    public boolean eduGuiVisible = false;
    public EduAdminGui currentEduAdminGuiTab;
    public int currentAdminMenuGroup = 1;
    public String skinTeacherMale = "mcedu_textures/mob/EduTeacherMale";
    public String skinTeacherFemale = "mcedu_textures/mob/EduTeacherFemale";
    public String skinStudentMale = "mcedu_textures/mob/EduStudentMale";
    public String skinStudentFemale = "mcedu_textures/mob/EduStudentFemale";
    public int skinStudentAmount = 28;
    public int skinTeacherAmount = 16;
    public int currentStudentSkin = 0;
    public int currentTeacherSkin = 0;
    public boolean debugWindowSize = false;
    public Point debugWindowPointPos = new Point(0, 480);
    public boolean debugPackets = false;
    public EduClientSettingsHandler clientSettingsFile;
    public EduClientServerSettings serverSettings;
    public EduClientPlayerSettings clientPlayerSettings;
    public EduClientPlayerBuildSettings clientBuildSettings;
    public ArrayList<EduHostingServer> hostingServers = new ArrayList();
    public EduHostingUserCredentials hostingUserData = new EduHostingUserCredentials("", "", "", "", "", "");
    public boolean reconnectNow = false;
    public boolean isReconnecting = false;
    public int reconnectCounter = 5;
    public EduClientReconnectThread reconnectThread;
    private static EduClientSettings singleton;

    public EduHostingServer getSelectedHostingServer() {
        for (EduHostingServer server : this.hostingServers) {
            if (!server.selected) continue;
            return server;
        }
        if (this.hostingServers.size() > 0) {
            return this.hostingServers.get(0);
        }
        return new EduHostingServer("", "", "", "", "", "", "", "", "", "");
    }

    public void setSelectedHostingServer(String serverName) {
        for (EduHostingServer server : this.hostingServers) {
            if (server.getServerName().equals(serverName)) {
                server.selected = true;
                continue;
            }
            server.selected = false;
        }
    }

    public boolean isLoggedInUsingWorldsAccount() {
        return this.hostingUserData != null && !this.hostingUserData.getHostingUsername().isEmpty() && !this.hostingUserData.getHostingPassword().isEmpty();
    }

    public String getPassableHostingToken() {
        String returnHostingToken = this.hostingUserData.getHostingToken() + ":" + this.getSelectedHostingServer().getServerId();
        return returnHostingToken == null ? "" : returnHostingToken;
    }

    private EduClientSettings() {
        if (this.serverSettings == null) {
            this.serverSettings = new EduClientServerSettings();
        }
        if (this.clientPlayerSettings == null) {
            this.clientPlayerSettings = new EduClientPlayerSettings();
        }
        if (this.clientBuildSettings == null) {
            this.clientBuildSettings = new EduClientPlayerBuildSettings();
        }
        this.initPaths("en");
        if (this.clientSettingsFile == null) {
            this.clientSettingsFile = new EduClientSettingsHandler(new File(this.pathEduSettingsFile), "");
        }
        this.clientSettingsFile.loadSettings();
        if (Datahandler.iniGet(this.pathLauncherSettingsFile, "writedebuglogtofile") != null && Datahandler.iniGet(this.pathLauncherSettingsFile, "writedebuglogtofile").equalsIgnoreCase("true")) {
            this.initFileDebugWriting();
        }
    }

    public String getAuthorText() {
        return "Minecraft " + Version.getMinecraftVersion() + " by Mojang AB. MinecraftEdu (" + Version.getFormattedVersion() + " build " + Version.getBuildNumber() + ", " + Version.getReleaseDate() + ", " + Version.getProtocolVersion() + ") by TeacherGaming LLC.";
    }

    public bqp getResourcePackMcEdu() {
        return null;
    }

    @Deprecated
    private void loadExternalJarClasses() {
        String overrideClassPath = Datahandler.iniGet(this.pathEduSettingsFile, "external_lib_path");
        if (overrideClassPath == null || overrideClassPath.trim().equals("")) {
            overrideClassPath = this.pathExternalLibraries;
        }
        HashMap<File, String> loadableJarClasses = new HashMap<File, String>();
        loadableJarClasses.put(new File(overrideClassPath + "commons-io-2.2.jar"), "org.apache.commons.io.FileUtils");
        EduClientFunctions.loadExternalClassesToClasspath(loadableJarClasses);
    }

    private void initFileDebugWriting() {
        try {
            HashMap<String, String> paths = new HashMap<String, String>();
            Field[] field = this.getClass().getSuperclass().getDeclaredFields();
            for (int i = 0; i < field.length; ++i) {
                if (!field[i].getName().toString().startsWith("path")) continue;
                paths.put(field[i].getName().toString(), (String)field[i].get(this));
            }
            EduClientFunctions.getS().enableDebugFileWriting(new File(this.pathDebugWritingFile), paths);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetServerSettings() {
        this.serverSettings.resetSettings();
        this.clientPlayerSettings.resetSettings();
        this.clientBuildSettings.resetSettings();
        this.clientBuildSettings.resetBuildModeValuesToDefault();
        this.isAdmin = false;
        this.eduGuiVisible = false;
    }

    private void createRequiredFiles() {
        File file2;
        File file = new File(this.pathLauncherSettingsFile);
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Could not create file");
                e.printStackTrace();
            }
        }
        if (!(file2 = new File(this.pathEduKeybindings)).exists()) {
            try {
                file2.getParentFile().mkdirs();
                file2.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Could not create file");
                e.printStackTrace();
            }
        }
    }

    public static EduClientSettings getS() {
        if (singleton == null) {
            singleton = new EduClientSettings();
        }
        return singleton;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

