/*
 * Decompiled with CFR 0.152.
 */
package mcedu.client;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcedu.EduAccessHelperClient;
import mcedu.blocks.EduBlockContainer;
import mcedu.blocks.EduBlockStore;
import mcedu.client.EduAdminGuiBuildTools;
import mcedu.client.EduAdminGuiGeneral;
import mcedu.client.EduAdminGuiGive;
import mcedu.client.EduAdminGuiTeleportStations;
import mcedu.client.EduAdminGuiUserSettings;
import mcedu.client.EduAdminGuiUsers;
import mcedu.client.EduAdminGuiWorld;
import mcedu.client.EduClientSettings;
import mcedu.client.EduGuiAssignments;
import mcedu.forgemod.EduKeyBindings;
import mcedu.global.Version;
import mcedu.global.hosting.HostingApiLogin;
import mcedu.global.tools.Security;
import net.minecraftforge.common.ForgeVersion;
import org.apache.commons.io.output.TeeOutputStream;
import org.lwjgl.input.Keyboard;

public class EduClientFunctions {
    private static EduClientFunctions singleton;

    public static void reconnectToHostingServer() {
        String username = EduClientSettings.getS().hostingUserData.getHostingUsername();
        String hashedPassword = EduClientSettings.getS().hostingUserData.getHostingPassword();
        EduClientSettings.getS().hostingUserData.setHostingToken(HostingApiLogin.getHostingAccessToken(username, hashedPassword, new File(EduClientSettings.getS().pathLauncherSettingsFile)));
        FMLClientHandler.instance().connectToServerAtStartup(EduClientSettings.getS().getSelectedHostingServer().getProxyAddress(), Integer.parseInt(EduClientSettings.getS().getSelectedHostingServer().getProxyPort()));
    }

    public static void loadExternalClassesToClasspath(HashMap<File, String> files) {
        String className = "";
        boolean loadOK = false;
        for (Map.Entry<File, String> entry : files.entrySet()) {
            loadOK = false;
            File file = entry.getKey();
            className = entry.getValue();
            try {
                Class.forName(className);
                loadOK = true;
            }
            catch (Exception e) {
                try {
                    if (!file.exists()) {
                        throw new IOException("File does not exist: " + file.getAbsolutePath());
                    }
                    if (!EduClientFunctions.addURLToClasspath(file.toURI().toURL())) {
                        throw new Exception("Could not load class!");
                    }
                    System.out.println("Loaded class " + entry.getKey().getAbsolutePath() + " manually.");
                }
                catch (Exception ex) {
                    System.out.println("Error loading class " + entry.getKey().getAbsolutePath() + " to classpath. Error: " + ex.getMessage());
                }
            }
            if (!loadOK) continue;
            System.out.println("Class " + entry.getValue() + " has already been loaded to classpath succesfully. Sweet!");
        }
    }

    private static boolean addURLToClasspath(URL file) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, file);
        return true;
    }

    public static void handleEduBindKeyPresses(bao mc, int pressedEventKey, boolean handleCommandKeypresses) {
        if (mc.G()) {
            return;
        }
        int i = pressedEventKey;
        if (i == 0 || i == 0) {
            return;
        }
        if (i == 50 && !EduClientSettings.getS().isAdmin) {
            EduAccessHelperClient.closeEduGui(mc);
            mc.a((bdw)new EduGuiAssignments(true));
            return;
        }
        if (!EduClientSettings.getS().isAdmin && EduClientSettings.getS().clientBuildSettings.isPlayerAllowedToUseBuildMode() && i == 48) {
            EduAccessHelperClient.closeEduGui(mc);
            mc.a((bdw)new EduAdminGuiBuildTools());
            return;
        }
        if (EduClientSettings.getS().isAdmin && !mc.h.getInPortal()) {
            EduKeyBindings.getS();
            if (EduKeyBindings.keyBindEduGuiPersonal.i() == i) {
                EduAccessHelperClient.closeEduGui(mc);
                mc.a((bdw)new EduAdminGuiUserSettings());
            } else {
                EduKeyBindings.getS();
                if (EduKeyBindings.keyBindEduGuiUsers.i() == i) {
                    EduAccessHelperClient.closeEduGui(mc);
                    mc.a((bdw)new EduAdminGuiUsers(true));
                } else {
                    EduKeyBindings.getS();
                    if (EduKeyBindings.keyBindEduGuiAssignment.i() == i) {
                        EduAccessHelperClient.closeEduGui(mc);
                        mc.a((bdw)new EduGuiAssignments(true));
                    } else {
                        EduKeyBindings.getS();
                        if (EduKeyBindings.keyBindEduGuiGeneral.i() == i) {
                            EduAccessHelperClient.closeEduGui(mc);
                            mc.a((bdw)new EduAdminGuiGeneral());
                        } else {
                            EduKeyBindings.getS();
                            if (EduKeyBindings.keyBindEduGuiBuildTools.i() == i) {
                                EduAccessHelperClient.closeEduGui(mc);
                                mc.a((bdw)new EduAdminGuiBuildTools());
                            } else {
                                EduKeyBindings.getS();
                                if (EduKeyBindings.keyBindEduGuiGive.i() == i) {
                                    EduAccessHelperClient.closeEduGui(mc);
                                    mc.a((bdw)new EduAdminGuiGive());
                                } else {
                                    EduKeyBindings.getS();
                                    if (EduKeyBindings.keyBindEduGuiStations.i() == i) {
                                        EduAccessHelperClient.closeEduGui(mc);
                                        mc.a((bdw)new EduAdminGuiTeleportStations(true));
                                    } else {
                                        EduKeyBindings.getS();
                                        if (EduKeyBindings.keyBindEduGuiWorld.i() == i) {
                                            EduAccessHelperClient.closeEduGui(mc);
                                            mc.a((bdw)new EduAdminGuiWorld());
                                        } else {
                                            EduKeyBindings.getS();
                                            if (EduKeyBindings.keyBindEduGuiLastAdminMenu.i() == i) {
                                                EduAccessHelperClient.closeEduGui(mc);
                                                mc.a((bdw)EduClientSettings.getS().currentEduAdminGuiTab);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (i == 25) {
                boolean flag = false;
                ArrayList<bal> keybindings = new ArrayList<bal>();
                EduKeyBindings.getS();
                keybindings.addAll(Arrays.asList(EduKeyBindings.eduCommandKeyBindings));
                EduKeyBindings.getS();
                keybindings.addAll(Arrays.asList(EduKeyBindings.eduMenuKeyBindings));
                keybindings.addAll(Arrays.asList(mc.u.as));
                for (bal k2 : keybindings) {
                    if (k2.i() != 25) continue;
                    flag = true;
                }
                if (!flag) {
                    StringBuilder stringBuilder = new StringBuilder().append(de.a().a("EduHooks.defaultTeacherMenuKeyChanged")).append(" ");
                    EduKeyBindings.getS();
                    EduAccessHelperClient.printChatMessageForPlayer(stringBuilder.append(Keyboard.getKeyName((int)EduKeyBindings.keyBindEduGuiLastAdminMenu.i())).append(".").toString());
                }
            }
            if (handleCommandKeypresses) {
                EduKeyBindings.getS();
                if (EduKeyBindings.keyBindEduCommandFreezeStudents.f()) {
                    EduAdminGuiUsers.commandFreezeStudentsNoGui(mc.h);
                } else {
                    EduKeyBindings.getS();
                    if (EduKeyBindings.keyBindEduCommandStudentsCanBuild.f()) {
                        EduAdminGuiWorld.commandStudentsCanBuild(mc.h);
                    } else {
                        EduKeyBindings.getS();
                        if (EduKeyBindings.keyBindEduCommandMoveSpeed.f()) {
                            EduAdminGuiUserSettings.commandToggleMovementSpeed((blk)mc.h);
                        } else {
                            EduKeyBindings.getS();
                            if (EduKeyBindings.keyBindEduCommandBuildMode.f()) {
                                EduAdminGuiBuildTools.commandToggleBuildMode(mc.h, mc);
                            } else {
                                EduKeyBindings.getS();
                                if (EduKeyBindings.keyBindEduCommandFillTool.f()) {
                                    EduAdminGuiBuildTools.commandToggleFillTool(mc.h, true);
                                } else {
                                    EduKeyBindings.getS();
                                    if (EduKeyBindings.keyBindEduCommandCreativeMode.f()) {
                                        EduAdminGuiUserSettings.commandToggleCreativeModeSelf(mc.h, mc, !EduClientSettings.getS().clientPlayerSettings.isPersonalCreativeModeEnabled());
                                    } else {
                                        EduKeyBindings.getS();
                                        if (EduKeyBindings.keyBindEduCommandLongBuild.f()) {
                                            EduAdminGuiBuildTools.commandToggleLongBuilding((blk)mc.h);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (EduClientSettings.getS().clientBuildSettings.isPlayerAllowedToUseBuildMode()) {
            EduKeyBindings.getS();
            if (EduKeyBindings.keyBindEduCommandBuildMode.f()) {
                EduAdminGuiBuildTools.commandToggleBuildMode(mc.h, mc);
            } else {
                EduKeyBindings.getS();
                if (EduKeyBindings.keyBindEduCommandFillTool.f()) {
                    EduAdminGuiBuildTools.commandToggleFillTool(mc.h, true);
                } else {
                    EduKeyBindings.getS();
                    if (EduKeyBindings.keyBindEduCommandCreativeMode.f()) {
                        EduAdminGuiUserSettings.commandToggleCreativeModeSelf(mc.h, mc, !EduClientSettings.getS().clientPlayerSettings.isPersonalCreativeModeEnabled());
                    } else {
                        EduKeyBindings.getS();
                        if (EduKeyBindings.keyBindEduCommandLongBuild.f()) {
                            EduAdminGuiBuildTools.commandToggleLongBuilding((blk)mc.h);
                        }
                    }
                }
            }
        }
    }

    public static int[] getCoordsForLocationString(String location) {
        try {
            String[] loc = location.split("\\.");
            return new int[]{Integer.parseInt(loc[0]), Integer.parseInt(loc[1]), Integer.parseInt(loc[2])};
        }
        catch (Exception e) {
            System.out.println("Could not split coordinates for location: " + location + ". Exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void setStudentSkinForPlayer(int currentSkin) {
        if (currentSkin % 2 == 0) {
            currentSkin = currentSkin == 2 ? 1 : (currentSkin /= 2);
            EduClientSettings.getS().clientPlayerSettings.setPlayerSkin(EduClientSettings.getS().skinStudentMale + currentSkin + ".png");
        } else {
            if (currentSkin != 1) {
                ++currentSkin;
                currentSkin /= 2;
            }
            EduClientSettings.getS().clientPlayerSettings.setPlayerSkin(EduClientSettings.getS().skinStudentFemale + currentSkin + ".png");
        }
    }

    public static void setTeacherSkinForPlayer(int currentSkin) {
        if (currentSkin % 2 == 0) {
            currentSkin = currentSkin == 2 ? 1 : (currentSkin /= 2);
            EduClientSettings.getS().clientPlayerSettings.setPlayerSkin(EduClientSettings.getS().skinTeacherMale + currentSkin + ".png");
        } else {
            if (currentSkin != 1) {
                ++currentSkin;
                currentSkin /= 2;
            }
            EduClientSettings.getS().clientPlayerSettings.setPlayerSkin(EduClientSettings.getS().skinTeacherFemale + currentSkin + ".png");
        }
    }

    public static String getPlayerSkin() {
        String skin = EduClientSettings.getS().clientPlayerSettings.getPlayerSkin();
        if (EduClientSettings.getS().clientSettingsFile.getUseCustomSkin()) {
            skin = "custom";
            EduClientSettings.getS().clientPlayerSettings.setPlayerCustomSkin(true);
        } else {
            EduClientSettings.getS().clientPlayerSettings.setPlayerCustomSkin(false);
        }
        return skin;
    }

    public String generateRandomPlayerUsername(boolean includePlayer) {
        String returnString = "";
        Random r = new Random();
        for (int i = 0; i < 6; ++i) {
            r.setSeed(System.currentTimeMillis());
            long sleepTime = 10 + (int)(Math.random() * 91.0);
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
            returnString = returnString + (sleepTime < 40L ? Long.toString(Math.abs(r.nextLong()), 36).substring(0, 1) : Security.getMd5(Integer.toString(r.nextInt())).substring(0, 1));
        }
        return includePlayer ? "Player" + returnString : returnString;
    }

    public double[] getBlockInCameraDirection(blk player, float step, int direction) {
        double pi = Math.PI / 180;
        double cosPitch = Math.cos((double)player.z * pi);
        double sinPitch = Math.sin((double)player.z * pi);
        double sinYaw = Math.sin((double)player.y * pi);
        double cosYaw = Math.cos((double)player.y * pi);
        double[] returnD = new double[3];
        if (direction == 200) {
            returnD[0] = player.s + (double)(-step) * (cosPitch * sinYaw);
            returnD[1] = player.t - (double)step * sinPitch;
            returnD[2] = player.u + (double)step * (cosPitch * cosYaw);
        } else if (direction == 208) {
            returnD[0] = player.s - (double)(-step) * (cosPitch * sinYaw);
            returnD[1] = player.t + (double)step * sinPitch;
            returnD[2] = player.u - (double)step * (cosPitch * cosYaw);
        } else if (direction == 57) {
            returnD[0] = player.s;
            returnD[1] = player.t + (double)step;
            returnD[2] = player.u;
        } else if (direction == 42) {
            returnD[0] = player.s;
            returnD[1] = player.t - (double)step;
            returnD[2] = player.u;
        }
        return returnD;
    }

    public void movePlayerToBlockPosition(blk player, float step, int direction) {
        double pi = Math.PI / 180;
        double sinYaw = Math.sin((double)player.y * pi);
        double cosYaw = Math.cos((double)player.y * pi);
        if (direction == 200) {
            player.s = (float)qh.c((double)(player.s + (double)(-step) * sinYaw)) + 0.5f;
            player.u = (float)qh.c((double)(player.u + (double)step * cosYaw)) + 0.5f;
        } else if (direction == 208) {
            player.s = (float)qh.c((double)(player.s - (double)(-step) * sinYaw)) + 0.5f;
            player.u = (float)qh.c((double)(player.u - (double)step * cosYaw)) + 0.5f;
        } else if (direction == 203) {
            player.s = (float)qh.c((double)(player.s - (double)step * Math.sin(Math.PI / 180 * (double)player.y - 1.5707963267948966))) + 0.5f;
            player.u = (float)qh.c((double)(player.u + (double)step * Math.cos(Math.PI / 180 * (double)player.y - 1.5707963267948966))) + 0.5f;
        } else if (direction == 205) {
            player.s = (float)qh.c((double)(player.s + (double)step * Math.sin(Math.PI / 180 * (double)player.y - 1.5707963267948966))) + 0.5f;
            player.u = (float)qh.c((double)(player.u - (double)step * Math.cos(Math.PI / 180 * (double)player.y - 1.5707963267948966))) + 0.5f;
        } else if (direction == 57) {
            player.t += (double)step;
        } else if (direction == 42) {
            player.t -= (double)step;
        }
    }

    @Deprecated
    public double[] getDistancesInCameraDirection(blk player, float step) {
        double[] returnD = new double[]{(double)step * Math.sin(Math.PI / 180 * (double)player.y), (double)step * Math.tan(Math.PI / 180 * (double)player.z), (double)step * Math.cos(Math.PI / 180 * (double)player.y)};
        return returnD;
    }

    public void movePlayerToCameraDirection(blk player, float step, int direction, boolean moveInY) {
        double pi = Math.PI / 180;
        double cosPitch = Math.cos((double)player.z * pi);
        double sinPitch = Math.sin((double)player.z * pi);
        double sinYaw = Math.sin((double)player.y * pi);
        double cosYaw = Math.cos((double)player.y * pi);
        double calcX = (double)(-step) * ((moveInY ? cosPitch : 1.0) * sinYaw);
        double calcZ = (double)step * ((moveInY ? cosPitch : 1.0) * cosYaw);
        double[] returnD = new double[3];
        if (direction == 200) {
            returnD[0] = player.s + calcX;
            returnD[1] = player.t - (double)step * sinPitch;
            returnD[2] = player.u + calcZ;
            player.s = returnD[0];
            if (moveInY) {
                player.t = returnD[1];
            }
            player.u = returnD[2];
        }
        if (direction == 208) {
            returnD[0] = player.s - calcX;
            returnD[1] = player.t + (double)step * sinPitch;
            returnD[2] = player.u - calcZ;
            player.s = returnD[0];
            if (moveInY) {
                player.t = returnD[1];
            }
            player.u = returnD[2];
        }
        if (direction == 203) {
            player.s -= (double)step * Math.sin(Math.PI / 180 * (double)player.y - 1.5707963267948966);
            player.u += (double)step * Math.cos(Math.PI / 180 * (double)player.y - 1.5707963267948966);
        }
        if (direction == 205) {
            player.s += (double)step * Math.sin(Math.PI / 180 * (double)player.y - 1.5707963267948966);
            player.u -= (double)step * Math.cos(Math.PI / 180 * (double)player.y - 1.5707963267948966);
        }
    }

    public int[] getIncreasedFacingDirectionCoordinates(yz player, int xIncrement, int yIncrement, int zIncrement) {
        int x = qh.c((double)player.s);
        int y2 = qh.c((double)player.t);
        int z2 = qh.c((double)player.u);
        int face = this.getPlayerDirection(player);
        int[] returnVal = new int[3];
        switch (face) {
            case 0: {
                x -= xIncrement;
                y2 += yIncrement;
                z2 += zIncrement;
                break;
            }
            case 1: {
                x -= zIncrement;
                y2 += yIncrement;
                z2 -= xIncrement;
                break;
            }
            case 2: {
                x += xIncrement;
                y2 += yIncrement;
                z2 -= zIncrement;
                break;
            }
            case 3: {
                x += zIncrement;
                y2 += yIncrement;
                z2 += xIncrement;
            }
        }
        returnVal[0] = x;
        returnVal[1] = y2;
        returnVal[2] = z2;
        return returnVal;
    }

    public int[] getIncreasedFacingDirectionCoordinates(yz player, int increment) {
        int x = qh.c((double)player.s);
        int y2 = qh.c((double)player.t);
        int z2 = qh.c((double)player.u);
        int face = this.getPlayerDirection(player);
        int[] returnVal = new int[3];
        switch (face) {
            case 0: {
                z2 += increment;
                break;
            }
            case 1: {
                x -= increment;
                break;
            }
            case 2: {
                z2 -= increment;
                break;
            }
            case 3: {
                x += increment;
            }
        }
        returnVal[0] = x;
        returnVal[1] = y2;
        returnVal[2] = z2;
        return returnVal;
    }

    public int getNextIncrementValueWithRange(int val, int increment, int min, int max) {
        val = increment > 0 ? (val + 1 > max ? max : (val + 1 < min ? min : val + 1)) : (val - 1 < min ? min : (val - 1 > max ? max : val - 1));
        return val;
    }

    public int getPlayerDirection(yz entityplayer) {
        return qh.c((double)((double)(entityplayer.y * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public EduBlockContainer getAreaOfBlocks(yz playerEntity, EduBlockStore blFirst, EduBlockStore blSecond) {
        int x1 = blFirst.x;
        int y1 = blFirst.y;
        int z1 = blFirst.z;
        int x2 = blSecond.x;
        int y2 = blSecond.y;
        int z2 = blSecond.z;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int hz = z2 - z1;
        int zdir = 1;
        int ydir = 1;
        int xdir = 1;
        if (hz < 0) {
            zdir = -1;
        }
        if (hy < 0) {
            ydir = -1;
        }
        if (hx < 0) {
            xdir = -1;
        }
        int dim = playerEntity.ap;
        EduBlockContainer returnContainer = new EduBlockContainer();
        returnContainer.addBlockToList(new EduBlockStore(blFirst.x, blFirst.y, blFirst.z, ajn.a, 0, dim));
        returnContainer.addBlockToList(new EduBlockStore(blSecond.x, blSecond.y, blSecond.z, ajn.a, 0, dim));
        for (int z3 = z1; z3 != z2 + zdir; z3 += zdir) {
            for (int y3 = y1; y3 != y2 + ydir; y3 += ydir) {
                for (int x = x1; x != x2 + xdir; x += xdir) {
                    returnContainer.addBlockToList(x, y3, z3, blSecond.block, blSecond.meta, dim);
                }
            }
        }
        return returnContainer;
    }

    public boolean enableDebugFileWriting(File debugFileLocation, HashMap<String, String> paths) {
        try {
            if (!debugFileLocation.exists()) {
                debugFileLocation.getParentFile().mkdirs();
                debugFileLocation.createNewFile();
            } else {
                debugFileLocation.delete();
                debugFileLocation.getParentFile().mkdirs();
                debugFileLocation.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(debugFileLocation);
            TeeOutputStream out = new TeeOutputStream(System.out, fos);
            PrintStream printstream = new PrintStream(out);
            System.setOut(printstream);
            SimpleDateFormat dateformat = new SimpleDateFormat("dd. MMMM. yyyy HH:mm");
            Date date = new Date();
            System.out.println("Debug logging for Minecraft Client started at: " + dateformat.format(date));
            System.out.println("###############################################");
            System.out.println("MinecraftEdu version: " + Version.getFormattedVersion() + " build " + Version.getBuildNumber() + " " + (Version.isClassroom() ? "Classroom" : "Premium"));
            System.out.println("Forge version: " + ForgeVersion.getVersion());
            System.out.println("PATHS:");
            for (Map.Entry<String, String> entry : paths.entrySet()) {
                System.out.println(entry.getKey() + " " + entry.getValue());
            }
            System.out.println("###############################################");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static EduClientFunctions getS() {
        if (singleton == null) {
            singleton = new EduClientFunctions();
        }
        return singleton;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

