/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.toposort;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.toposort.TopologicalSort;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModSorter {
    private TopologicalSort.DirectedGraph<ModContainer> modGraph;
    private ModContainer beforeAll = new DummyModContainer("BeforeAll");
    private ModContainer afterAll = new DummyModContainer("AfterAll");
    private ModContainer before = new DummyModContainer("Before");
    private ModContainer after = new DummyModContainer("After");

    public ModSorter(List<ModContainer> modList, Map<String, ModContainer> nameLookup) {
        HashMap sortingNameLookup = Maps.newHashMap(nameLookup);
        ModAPIManager.INSTANCE.injectAPIModContainers(modList, sortingNameLookup);
        this.buildGraph(modList, sortingNameLookup);
    }

    private void buildGraph(List<ModContainer> modList, Map<String, ModContainer> nameLookup) {
        this.modGraph = new TopologicalSort.DirectedGraph();
        this.modGraph.addNode(this.beforeAll);
        this.modGraph.addNode(this.before);
        this.modGraph.addNode(this.afterAll);
        this.modGraph.addNode(this.after);
        this.modGraph.addEdge(this.before, this.after);
        this.modGraph.addEdge(this.beforeAll, this.before);
        this.modGraph.addEdge(this.after, this.afterAll);
        for (ModContainer mod : modList) {
            this.modGraph.addNode(mod);
        }
        for (ModContainer mod : modList) {
            String modid;
            if (mod.isImmutable()) {
                this.modGraph.addEdge(this.beforeAll, mod);
                this.modGraph.addEdge(mod, this.before);
                continue;
            }
            boolean preDepAdded = false;
            boolean postDepAdded = false;
            for (ArtifactVersion dep : mod.getDependencies()) {
                preDepAdded = true;
                modid = dep.getLabel();
                if (modid.equals("*")) {
                    this.modGraph.addEdge(mod, this.afterAll);
                    this.modGraph.addEdge(this.after, mod);
                    postDepAdded = true;
                    continue;
                }
                this.modGraph.addEdge(this.before, mod);
                if (!Loader.isModLoaded(modid)) continue;
                this.modGraph.addEdge(nameLookup.get(modid), mod);
            }
            for (ArtifactVersion dep : mod.getDependants()) {
                postDepAdded = true;
                modid = dep.getLabel();
                if (modid.equals("*")) {
                    this.modGraph.addEdge(this.beforeAll, mod);
                    this.modGraph.addEdge(mod, this.before);
                    preDepAdded = true;
                    continue;
                }
                this.modGraph.addEdge(mod, this.after);
                if (!Loader.isModLoaded(modid)) continue;
                this.modGraph.addEdge(mod, nameLookup.get(modid));
            }
            if (!preDepAdded) {
                this.modGraph.addEdge(this.before, mod);
            }
            if (postDepAdded) continue;
            this.modGraph.addEdge(mod, this.after);
        }
    }

    public List<ModContainer> sort() {
        List<ModContainer> sortedList = TopologicalSort.topologicalSort(this.modGraph);
        sortedList.removeAll(Arrays.asList(this.beforeAll, this.before, this.after, this.afterAll));
        return sortedList;
    }
}

