/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.MobType;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.data.InvalidFormatException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobSpawnerBlock
extends BaseBlock
implements TileEntityBlock {
    private String mobType;
    private short delay;
    private short spawnCount;
    private short spawnRange;
    private CompoundTag spawnData;
    private ListTag spawnPotentials;
    private short minSpawnDelay;
    private short maxSpawnDelay;
    private short maxNearbyEntities;
    private short requiredPlayerRange;

    public MobSpawnerBlock() {
        super(52);
        this.mobType = MobType.PIG.getName();
    }

    public MobSpawnerBlock(String mobType) {
        super(52);
        this.mobType = mobType;
    }

    public MobSpawnerBlock(int data) {
        super(52, data);
    }

    public MobSpawnerBlock(int data, String mobType) {
        super(52, data);
        this.mobType = mobType;
    }

    public String getMobType() {
        return this.mobType;
    }

    public void setMobType(String mobType) {
        this.mobType = mobType;
    }

    public short getDelay() {
        return this.delay;
    }

    public void setDelay(short delay) {
        this.delay = delay;
    }

    @Override
    public boolean hasNbtData() {
        return true;
    }

    @Override
    public String getNbtId() {
        return "MobSpawner";
    }

    @Override
    public CompoundTag getNbtData() {
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("EntityId", new StringTag("EntityId", this.mobType));
        values.put("Delay", new ShortTag("Delay", this.delay));
        values.put("SpawnCount", new ShortTag("SpawnCount", this.spawnCount));
        values.put("SpawnRange", new ShortTag("SpawnRange", this.spawnRange));
        values.put("MinSpawnDelay", new ShortTag("MinSpawnDelay", this.minSpawnDelay));
        values.put("MaxSpawnDelay", new ShortTag("MaxSpawnDelay", this.maxSpawnDelay));
        values.put("MaxNearbyEntities", new ShortTag("MaxNearbyEntities", this.maxNearbyEntities));
        values.put("RequiredPlayerRange", new ShortTag("RequiredPlayerRange", this.requiredPlayerRange));
        values.put("SpawnData", new CompoundTag("SpawnData", (Map<String, Tag>)(this.spawnData == null ? null : this.spawnData.getValue())));
        values.put("SpawnPotentials", new ListTag("SpawnPotentials", (Class<? extends Tag>)CompoundTag.class, (List<? extends Tag>)(this.spawnPotentials == null ? null : this.spawnPotentials.getValue())));
        return new CompoundTag(this.getNbtId(), values);
    }

    @Override
    public void setNbtData(CompoundTag rootTag) throws DataException {
        if (rootTag == null) {
            return;
        }
        Object values = rootTag.getValue();
        Tag t = (Tag)values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("MobSpawner")) {
            throw new DataException("'MobSpawner' tile entity expected");
        }
        StringTag mobTypeTag = NBTUtils.getChildTag((Map<String, Tag>)values, "EntityId", StringTag.class);
        ShortTag delayTag = NBTUtils.getChildTag((Map<String, Tag>)values, "Delay", ShortTag.class);
        this.mobType = mobTypeTag.getValue();
        this.delay = delayTag.getValue();
        ShortTag spawnCountTag = null;
        ShortTag spawnRangeTag = null;
        ShortTag minSpawnDelayTag = null;
        ShortTag maxSpawnDelayTag = null;
        ShortTag maxNearbyEntitiesTag = null;
        ShortTag requiredPlayerRangeTag = null;
        ListTag spawnPotentialsTag = null;
        CompoundTag spawnDataTag = null;
        try {
            spawnCountTag = NBTUtils.getChildTag((Map<String, Tag>)values, "SpawnCount", ShortTag.class);
            spawnRangeTag = NBTUtils.getChildTag((Map<String, Tag>)values, "SpawnRange", ShortTag.class);
            minSpawnDelayTag = NBTUtils.getChildTag((Map<String, Tag>)values, "MinSpawnDelay", ShortTag.class);
            maxSpawnDelayTag = NBTUtils.getChildTag((Map<String, Tag>)values, "MaxSpawnDelay", ShortTag.class);
            maxNearbyEntitiesTag = NBTUtils.getChildTag((Map<String, Tag>)values, "MaxNearbyEntities", ShortTag.class);
            requiredPlayerRangeTag = NBTUtils.getChildTag((Map<String, Tag>)values, "RequiredPlayerRange", ShortTag.class);
            spawnPotentialsTag = NBTUtils.getChildTag((Map<String, Tag>)values, "SpawnPotentials", ListTag.class);
            spawnDataTag = NBTUtils.getChildTag((Map<String, Tag>)values, "SpawnData", CompoundTag.class);
        }
        catch (InvalidFormatException e) {
            // empty catch block
        }
        this.spawnCount = spawnCountTag == null ? null : spawnCountTag.getValue();
        this.spawnRange = spawnRangeTag == null ? null : spawnRangeTag.getValue();
        this.minSpawnDelay = minSpawnDelayTag == null ? null : minSpawnDelayTag.getValue();
        this.maxSpawnDelay = maxSpawnDelayTag == null ? null : maxSpawnDelayTag.getValue();
        this.maxNearbyEntities = maxNearbyEntitiesTag == null ? null : maxNearbyEntitiesTag.getValue();
        this.requiredPlayerRange = requiredPlayerRangeTag == null ? null : requiredPlayerRangeTag.getValue();
        this.spawnPotentials = new ListTag("SpawnPotentials", CompoundTag.class, (List<? extends Tag>)(spawnPotentialsTag == null ? null : spawnPotentialsTag.getValue()));
        this.spawnData = new CompoundTag("SpawnData", (Map<String, Tag>)(spawnDataTag == null ? null : spawnDataTag.getValue()));
    }
}

