/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.dto.McoServer;
import com.mojang.realmsclient.gui.EditOnlineWorldScreen;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsSliderButton;
import org.lwjgl.input.Keyboard;

public class OnlineWorldSettingsSubScreen
extends RealmsScreen {
    private static final int DONE_BUTTON_ID = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int DIFFICULTY_BUTTON_ID = 2;
    private static final int GAMEMODE_BUTTON_ID = 3;
    private static final int PVP_BUTTON_ID = 4;
    private static final int SPAWN_ANIMALS_BUTTON_ID = 5;
    private static final int SPAWN_MONSTERS_BUTTON_ID = 6;
    private static final int SPAWN_NPCS_BUTTON_ID = 7;
    private static final int SPAWN_PROTECTION_BUTTON_ID = 8;
    private static final int COMMANDBLOCKS_BUTTON_ID = 9;
    protected final EditOnlineWorldScreen parent;
    private int column1_x;
    private int column_width;
    private int column2_x;
    private McoServer serverData;
    private int difficultyIndex;
    private int gameModeIndex;
    private Boolean pvp;
    private Boolean spawnNPCs;
    private Boolean spawnAnimals;
    private Boolean spawnMonsters;
    private Integer spawnProtection;
    private Boolean commandBlocks;
    private RealmsButton pvpButton;
    private RealmsButton spawnAnimalsButton;
    private RealmsButton spawnMonstersButton;
    private RealmsButton spawnNPCsButton;
    private RealmsSliderButton spawnProtectionButton;
    private RealmsButton commandBlocksButton;
    String[] difficulties;
    String[] gameModes;
    String[][] gameModeHints;

    public OnlineWorldSettingsSubScreen(EditOnlineWorldScreen parent, McoServer serverData) {
        this.parent = parent;
        this.serverData = serverData;
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 0) {
            this.parent.saveServerData(this.difficultyIndex, this.gameModeIndex, this.pvp, this.spawnNPCs, this.spawnAnimals, this.spawnMonsters, this.spawnProtection, this.commandBlocks);
            this.parent.confirmResult(true, 0);
        } else if (button.id() == 1) {
            this.parent.confirmResult(false, 1);
        } else if (button.id() == 2) {
            this.difficultyIndex = (this.difficultyIndex + 1) % this.difficulties.length;
            button.msg(this.difficultyTitle());
            this.spawnMonstersButton.active(this.difficultyIndex != 0);
            this.spawnMonstersButton.msg(this.spawnMonstersTitle());
        } else if (button.id() == 3) {
            this.gameModeIndex = (this.gameModeIndex + 1) % this.gameModes.length;
            button.msg(this.gameModeTitle());
        } else if (button.id() == 4) {
            this.pvp = this.pvp == false;
            button.msg(this.pvpTitle());
        } else if (button.id() == 5) {
            this.spawnAnimals = this.spawnAnimals == false;
            button.msg(this.spawnAnimalsTitle());
        } else if (button.id() == 7) {
            this.spawnNPCs = this.spawnNPCs == false;
            button.msg(this.spawnNPCsTitle());
        } else if (button.id() == 6) {
            this.spawnMonsters = this.spawnMonsters == false;
            button.msg(this.spawnMonstersTitle());
        } else if (button.id() == 9) {
            this.commandBlocks = this.commandBlocks == false;
            button.msg(this.commandBlocksTitle());
        }
    }

    public void keyPressed(char eventCharacter, int eventKey) {
        if (eventKey == 1) {
            this.parent.confirmResult(false, 1);
        }
    }

    public void init() {
        this.column1_x = 4 + this.width() / 8;
        this.column_width = this.width() / 2 - 4 - this.width() / 8;
        this.column2_x = this.width() / 2 + 4;
        this.createDifficultyAndGameMode();
        this.difficultyIndex = this.serverData.difficulty;
        this.gameModeIndex = this.serverData.gameMode;
        this.pvp = this.serverData.options.pvp;
        this.spawnAnimals = this.serverData.options.spawnAnimals;
        this.spawnMonsters = this.serverData.options.spawnMonsters;
        this.spawnNPCs = this.serverData.options.spawnNPCs;
        this.spawnProtection = this.serverData.options.spawnProtection;
        this.commandBlocks = this.serverData.options.commandBlocks;
        this.pvpButton = OnlineWorldSettingsSubScreen.newButton((int)4, (int)this.column1_x, (int)(this.height() / 4 + 0), (int)this.column_width, (int)20, (String)this.pvpTitle());
        this.buttonsAdd(this.pvpButton);
        this.buttonsAdd(OnlineWorldSettingsSubScreen.newButton((int)2, (int)this.column1_x, (int)(this.height() / 4 + 24), (int)this.column_width, (int)20, (String)this.difficultyTitle()));
        this.spawnProtectionButton = new SettingsSlider(8, this.column1_x, this.height() / 4 + 48, this.column_width, 17, this.spawnProtection, 0.0f, 16.0f);
        this.buttonsAdd((RealmsButton)this.spawnProtectionButton);
        this.buttonsAdd(OnlineWorldSettingsSubScreen.newButton((int)3, (int)this.column1_x, (int)(this.height() / 4 + 72), (int)this.column_width, (int)20, (String)this.gameModeTitle()));
        this.spawnAnimalsButton = OnlineWorldSettingsSubScreen.newButton((int)5, (int)this.column2_x, (int)(this.height() / 4 + 0), (int)this.column_width, (int)20, (String)this.spawnAnimalsTitle());
        this.buttonsAdd(this.spawnAnimalsButton);
        this.spawnMonstersButton = OnlineWorldSettingsSubScreen.newButton((int)6, (int)this.column2_x, (int)(this.height() / 4 + 24), (int)this.column_width, (int)20, (String)this.spawnMonstersTitle());
        this.buttonsAdd(this.spawnMonstersButton);
        this.spawnNPCsButton = OnlineWorldSettingsSubScreen.newButton((int)7, (int)this.column2_x, (int)(this.height() / 4 + 48), (int)this.column_width, (int)20, (String)this.spawnNPCsTitle());
        this.buttonsAdd(this.spawnNPCsButton);
        this.commandBlocksButton = OnlineWorldSettingsSubScreen.newButton((int)9, (int)this.column2_x, (int)(this.height() / 4 + 72), (int)this.column_width, (int)20, (String)this.commandBlocksTitle());
        this.buttonsAdd(this.commandBlocksButton);
        if (!this.serverData.worldType.equals((Object)McoServer.WorldType.NORMAL)) {
            this.pvpButton.active(false);
            this.spawnAnimalsButton.active(false);
            this.spawnNPCsButton.active(false);
            this.spawnMonstersButton.active(false);
            this.spawnProtectionButton.active(false);
            this.commandBlocksButton.active(false);
        }
        if (this.difficultyIndex == 0) {
            this.spawnMonstersButton.active(false);
        }
        this.buttonsAdd(OnlineWorldSettingsSubScreen.newButton((int)0, (int)this.column1_x, (int)(this.height() / 4 + 120 + 22), (int)this.column_width, (int)20, (String)OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.buttons.done")));
        this.buttonsAdd(OnlineWorldSettingsSubScreen.newButton((int)1, (int)this.column2_x, (int)(this.height() / 4 + 120 + 22), (int)this.column_width, (int)20, (String)OnlineWorldSettingsSubScreen.getLocalizedString((String)"gui.cancel")));
    }

    private void createDifficultyAndGameMode() {
        this.difficulties = new String[]{OnlineWorldSettingsSubScreen.getLocalizedString((String)"options.difficulty.peaceful"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"options.difficulty.easy"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"options.difficulty.normal"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"options.difficulty.hard")};
        this.gameModes = new String[]{OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.survival"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.creative"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.adventure")};
        this.gameModeHints = new String[][]{{OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.survival.line1"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.survival.line2")}, {OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.creative.line1"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.creative.line2")}, {OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.adventure.line1"), OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode.adventure.line2")}};
    }

    private String difficultyTitle() {
        String difficulty = OnlineWorldSettingsSubScreen.getLocalizedString((String)"options.difficulty");
        return difficulty + ": " + this.difficulties[this.difficultyIndex];
    }

    private String gameModeTitle() {
        String gameMode = OnlineWorldSettingsSubScreen.getLocalizedString((String)"selectWorld.gameMode");
        return gameMode + ": " + this.gameModes[this.gameModeIndex];
    }

    private String pvpTitle() {
        return OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.pvp") + ": " + (this.pvp != false ? OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.on") : OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.off"));
    }

    private String spawnAnimalsTitle() {
        return OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.spawnAnimals") + ": " + (this.spawnAnimals != false ? OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.on") : OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.off"));
    }

    private String spawnMonstersTitle() {
        if (this.difficultyIndex == 0) {
            return OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.spawnMonsters") + ": " + OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.off");
        }
        return OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.spawnMonsters") + ": " + (this.spawnMonsters != false ? OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.on") : OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.off"));
    }

    private String spawnNPCsTitle() {
        return OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.spawnNPCs") + ": " + (this.spawnNPCs != false ? OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.on") : OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.off"));
    }

    private String commandBlocksTitle() {
        return OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.commandBlocks") + ": " + (this.commandBlocks != false ? OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.on") : OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.off"));
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(OnlineWorldSettingsSubScreen.getLocalizedString((String)"mco.configure.world.edit.subscreen.title"), this.width() / 2, 17, 0xFFFFFF);
        this.renderHints();
        super.render(xm, ym, a);
    }

    public void renderHints() {
        this.drawString(this.gameModeHints[this.gameModeIndex][0], this.column1_x + 2, this.height() / 4 + 96 + 2, 0xA0A0A0);
        this.drawString(this.gameModeHints[this.gameModeIndex][1], this.column1_x + 2, this.height() / 4 + 96 + 2 + this.fontLineHeight(), 0xA0A0A0);
    }

    public void mouseReleased(int x, int y, int buttonNum) {
        this.spawnProtectionButton.released(x, y);
    }

    public void mouseDragged(int x, int y, int buttonNum, long delta) {
        this.spawnProtectionButton.clicked(x, y);
    }

    private class SettingsSlider
    extends RealmsSliderButton {
        public SettingsSlider(int id, int x, int y, int width, int steps, int currentValue, float minValue, float maxValue) {
            super(id, x, y, width, steps, currentValue, minValue, maxValue);
        }

        public String getMessage() {
            return RealmsScreen.getLocalizedString((String)"mco.configure.world.spawnProtection") + ": " + (OnlineWorldSettingsSubScreen.this.spawnProtection == 0 ? RealmsScreen.getLocalizedString((String)"mco.configure.world.off") : OnlineWorldSettingsSubScreen.this.spawnProtection);
        }

        public void clicked(float value) {
            OnlineWorldSettingsSubScreen.this.spawnProtection = (int)value;
        }
    }
}

