/*
 * Decompiled with CFR 0.152.
 */
package desktoplauncher;

import desktoplauncher.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class main {
    private static String sep = System.getProperty("file.separator");
    private static final String DEFAULT_CLIENT_RAM = "700";
    private static final String SETTING_RAM = "client-ram";
    private static final String LAUNCHER_FILENAME = "Launcher.jar";

    public static void main(String[] args) {
        String path = "";
        try {
            path = main.readEduPath("/desktoplauncher/edupath.ini");
            main.startEduLauncher(path);
        }
        catch (Exception e) {
            main.showErrorMessagebox(e, path);
            e.printStackTrace();
        }
    }

    private static void startEduLauncher(String path) throws Exception {
        String pathLauncher = path = new File(path).getAbsolutePath();
        if (!new File(path).exists()) {
            throw new FileNotFoundException("MinecraftEdu folder was not found. Should be here: " + path);
        }
        if (!new File(pathLauncher).exists()) {
            throw new FileNotFoundException("Path to MinecraftEdu launcher was not found. Should be here: " + pathLauncher);
        }
        if (!new File(pathLauncher + sep + LAUNCHER_FILENAME).exists()) {
            throw new FileNotFoundException("Launcher file was not found. Should be here: " + pathLauncher + sep + LAUNCHER_FILENAME);
        }
        String ram = main.getRamMemory(new File(path));
        main.launchJarFile(new File(pathLauncher), LAUNCHER_FILENAME, ram, ram, null);
        System.exit(0);
    }

    public static void launchJarFile(File pathToFolder, String jarFileToLaunch, String xmxRam, String xmsRam, String[] arguments) throws Exception {
        String javaStart = "java";
        if (System.getProperty("os.name").startsWith("Windows")) {
            javaStart = System.getProperty("java.home") + "\\bin\\javaw";
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-Xmx" + xmxRam + "M");
        commands.add("-Xms" + xmsRam + "M");
        commands.add("-jar");
        commands.add(jarFileToLaunch);
        if (arguments != null) {
            commands.addAll(Arrays.asList(arguments));
        }
        main.launchExternalProgram(pathToFolder, javaStart, commands.toArray(new String[commands.size()]));
    }

    public static void launchExternalProgram(File pathToLaunchFolder, String programToLaunch, String[] arguments) throws Exception {
        ArrayList<String> processParams = new ArrayList<String>();
        processParams.add(programToLaunch);
        for (String string : arguments) {
            processParams.add(string);
        }
        ProcessBuilder pb = new ProcessBuilder(processParams);
        String par = "";
        for (Object e : processParams) {
            par = par + " " + (String)e;
        }
        System.out.println("Pars: " + par);
        pb.directory(pathToLaunchFolder);
        pb.start();
    }

    private static String getRamMemory(File installPath) {
        String iniSetting = Util.iniGet(installPath.getAbsolutePath() + sep + "launcher_res/settings/launchersettings.ini", SETTING_RAM);
        if (iniSetting == null || iniSetting.trim().equals("")) {
            return DEFAULT_CLIENT_RAM;
        }
        return iniSetting;
    }

    private static void showErrorMessagebox(Exception e, String installPath) {
        JOptionPane.showMessageDialog(null, "<html>MinecraftEdu Launch Failed.<br>Reason: " + e.toString() + "<br>Path where launch was tried: " + installPath + "</html>", "MinecraftEdu Launch Failed", 0);
    }

    private static String readEduPath(String fileResourceName) throws Exception {
        InputStream in = main.class.getResourceAsStream(fileResourceName);
        if (in == null) {
            return new File(Util.getApplicationDataFolder().getAbsolutePath() + sep + "minecraftedu").getAbsolutePath();
        }
        String content = main.convertStreamToString(in);
        if (content == null || content.equals("")) {
            return Util.getApplicationDataFolder().getAbsolutePath();
        }
        if (content.equalsIgnoreCase("usecurrentfolder")) {
            return new File("./").getAbsolutePath();
        }
        return content;
    }

    public static String convertStreamToString(InputStream is) {
        try {
            return new Scanner(is).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }
}

