/*
 * Decompiled with CFR 0.152.
 */
package desktoplauncher;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Util {
    private static File workDir = null;

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WINDOWS;
        }
        if (osName.contains("mac")) {
            return OS.MACOS;
        }
        if (osName.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (osName.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (osName.contains("linux")) {
            return OS.LINUX;
        }
        if (osName.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static File getApplicationDataFolder() {
        File workingDirectory;
        String userHome = System.getProperty("user.home", "");
        switch (Util.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                workingDirectory = new File(userHome);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                workingDirectory = new File(folder);
                break;
            }
            case MACOS: {
                workingDirectory = new File(userHome, "Library/Application Support/");
                break;
            }
            default: {
                workingDirectory = new File(userHome);
            }
        }
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + workingDirectory);
        }
        return workingDirectory;
    }

    public static String iniGet(String file, String setting) {
        Properties ini = new Properties();
        setting = setting.toLowerCase();
        try {
            FileInputStream fis = new FileInputStream(file);
            ini.load(fis);
            fis.close();
            return ini.getProperty(setting);
        }
        catch (Exception e) {
            System.out.println("Error reading ini file: " + e);
            return "";
        }
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS,
        UNKNOWN;

    }
}

