/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.List;

public class FMLMissingMappingsEvent
extends FMLEvent {
    private ListMultimap<String, MissingMapping> missing;
    private ModContainer activeContainer;

    public FMLMissingMappingsEvent(ListMultimap<String, MissingMapping> missingMappings) {
        this.missing = missingMappings;
    }

    @Override
    public void applyModContainer(ModContainer activeContainer) {
        super.applyModContainer(activeContainer);
        this.activeContainer = activeContainer;
    }

    public List<MissingMapping> get() {
        return ImmutableList.copyOf((Collection)this.missing.get((Object)this.activeContainer.getModId()));
    }

    public List<MissingMapping> getAll() {
        return ImmutableList.copyOf((Collection)this.missing.values());
    }

    public static class MissingMapping {
        public final GameRegistry.Type type;
        public final String name;
        public final int id;
        private Action action = Action.DEFAULT;
        private Object target;

        public MissingMapping(String name, int id) {
            this.type = name.charAt(0) == '\u0001' ? GameRegistry.Type.BLOCK : GameRegistry.Type.ITEM;
            this.name = name.substring(1);
            this.id = id;
        }

        @Deprecated
        public void setAction(Action target) {
            if (target == Action.DEFAULT || target == Action.REMAP) {
                throw new IllegalArgumentException();
            }
            this.action = target;
        }

        public void ignore() {
            this.action = Action.IGNORE;
        }

        public void warn() {
            this.action = Action.WARN;
        }

        public void fail() {
            this.action = Action.FAIL;
        }

        public void remap(aji target) {
            if (this.type != GameRegistry.Type.BLOCK) {
                throw new IllegalArgumentException("Can't remap an item to a block.");
            }
            if (target == null) {
                throw new NullPointerException("remap target is null");
            }
            if (GameData.getBlockRegistry().getId(target) < 0) {
                throw new IllegalArgumentException(String.format("The specified block %s hasn't been registered at startup.", target));
            }
            this.action = Action.REMAP;
            this.target = target;
        }

        public void remap(adb target) {
            if (this.type != GameRegistry.Type.ITEM) {
                throw new IllegalArgumentException("Can't remap a block to an item.");
            }
            if (target == null) {
                throw new NullPointerException("remap target is null");
            }
            if (GameData.getItemRegistry().getId(target) < 0) {
                throw new IllegalArgumentException(String.format("The specified item %s hasn't been registered at startup.", target));
            }
            this.action = Action.REMAP;
            this.target = target;
        }

        public Action getAction() {
            return this.action;
        }

        public Object getTarget() {
            return this.target;
        }
    }

    public static enum Action {
        DEFAULT,
        IGNORE,
        WARN,
        FAIL,
        REMAP;

    }
}

