/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.MCPDummyContainer;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MinecraftDummyContainer;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.functions.ArtifactVersionNameFunction;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ObjectHolderRegistry;
import cpw.mods.fml.common.toposort.ModSorter;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class Loader {
    public static final String MC_VERSION = "1.7.10";
    private static final Splitter DEPENDENCYPARTSPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();
    private static final Splitter DEPENDENCYSPLITTER = Splitter.on((String)";").omitEmptyStrings().trimResults();
    private static Loader instance;
    private static String major;
    private static String minor;
    private static String rev;
    private static String build;
    private static String mccversion;
    private static String mcpversion;
    private ModClassLoader modClassLoader = new ModClassLoader(this.getClass().getClassLoader());
    private List<ModContainer> mods;
    private Map<String, ModContainer> namedMods;
    private ListMultimap<String, String> reverseDependencies;
    private File canonicalConfigDir;
    private File canonicalModsDir;
    private LoadController modController;
    private MinecraftDummyContainer minecraft;
    private MCPDummyContainer mcp;
    private static File minecraftDir;
    private static List<String> injectedContainers;
    private ImmutableMap<String, String> fmlBrandingProperties;
    private File forcedModFile;
    private ModDiscoverer discoverer;

    public static Loader instance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    public static void injectData(Object ... data) {
        major = (String)data[0];
        minor = (String)data[1];
        rev = (String)data[2];
        build = (String)data[3];
        mccversion = (String)data[4];
        mcpversion = (String)data[5];
        minecraftDir = (File)data[6];
        injectedContainers = (List)data[7];
    }

    private Loader() {
        if (!mccversion.equals(MC_VERSION)) {
            FMLLog.severe("This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", mccversion, MC_VERSION);
            throw new LoaderException();
        }
        this.minecraft = new MinecraftDummyContainer(MC_VERSION);
        this.mcp = new MCPDummyContainer(MetadataCollection.from(this.getClass().getResourceAsStream("/mcpmod.info"), "MCP").getMetadataForId("mcp", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortModList() {
        FMLLog.finer("Verifying mod requirements are satisfied", new Object[0]);
        try {
            HashBiMap modVersions = HashBiMap.create();
            for (ModContainer mod : Iterables.concat(this.getActiveModList(), ModAPIManager.INSTANCE.getAPIList())) {
                modVersions.put((Object)mod.getModId(), (Object)mod.getProcessedVersion());
            }
            ArrayListMultimap reqList = ArrayListMultimap.create();
            for (ModContainer mod : this.getActiveModList()) {
                if (!mod.acceptableMinecraftVersionRange().containsVersion(this.minecraft.getProcessedVersion())) {
                    FMLLog.severe("The mod %s does not wish to run in Minecraft version %s. You will have to remove it to play.", mod.getModId(), this.getMCVersionString());
                    throw new WrongMinecraftVersionException(mod);
                }
                ImmutableMap names = Maps.uniqueIndex(mod.getRequirements(), (Function)new ArtifactVersionNameFunction());
                HashSet versionMissingMods = Sets.newHashSet();
                Sets.SetView missingMods = Sets.difference(names.keySet(), (Set)modVersions.keySet());
                if (!missingMods.isEmpty()) {
                    FMLLog.severe("The mod %s (%s) requires mods %s to be available", mod.getModId(), mod.getName(), missingMods);
                    for (String modid : missingMods) {
                        versionMissingMods.add(names.get(modid));
                    }
                    throw new MissingModsException(versionMissingMods);
                }
                reqList.putAll((Object)mod.getModId(), names.keySet());
                ImmutableList allDeps = ImmutableList.builder().addAll(mod.getDependants()).addAll(mod.getDependencies()).build();
                for (ArtifactVersion v : allDeps) {
                    if (!modVersions.containsKey((Object)v.getLabel()) || v.containsVersion((ArtifactVersion)modVersions.get((Object)v.getLabel()))) continue;
                    versionMissingMods.add(v);
                }
                if (versionMissingMods.isEmpty()) continue;
                FMLLog.severe("The mod %s (%s) requires mod versions %s to be available", mod.getModId(), mod.getName(), versionMissingMods);
                throw new MissingModsException(versionMissingMods);
            }
            FMLLog.finer("All mod requirements are satisfied", new Object[0]);
            this.reverseDependencies = (ListMultimap)Multimaps.invertFrom((Multimap)reqList, (Multimap)ArrayListMultimap.create());
            ModSorter sorter = new ModSorter(this.getActiveModList(), this.namedMods);
            try {
                FMLLog.finer("Sorting mods into an ordered list", new Object[0]);
                List<ModContainer> sortedMods = sorter.sort();
                this.modController.getActiveModList().clear();
                this.modController.getActiveModList().addAll(sortedMods);
                this.mods.removeAll(sortedMods);
                sortedMods.addAll(this.mods);
                this.mods = sortedMods;
                FMLLog.finer("Mod sorting completed successfully", new Object[0]);
            }
            catch (ModSortingException sortException) {
                FMLLog.severe("A dependency cycle was detected in the input mod set so an ordering cannot be determined", new Object[0]);
                ModSortingException.SortingExceptionData exceptionData = sortException.getExceptionData();
                FMLLog.severe("The first mod in the cycle is %s", exceptionData.getFirstBadNode());
                FMLLog.severe("The mod cycle involves", new Object[0]);
                for (ModContainer mc : exceptionData.getVisitedNodes()) {
                    FMLLog.severe("%s : before: %s, after: %s", mc.toString(), mc.getDependants(), mc.getDependencies());
                }
                FMLLog.log(Level.ERROR, sortException, "The full error", new Object[0]);
                throw sortException;
            }
        }
        catch (Throwable throwable) {
            FMLLog.fine("Mod sorting data", new Object[0]);
            int unprintedMods = this.mods.size();
            for (ModContainer mod : this.getActiveModList()) {
                if (mod.isImmutable()) continue;
                FMLLog.fine("\t%s(%s:%s): %s (%s)", mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), mod.getSortingRules());
                --unprintedMods;
            }
            if (unprintedMods == this.mods.size()) {
                FMLLog.fine("No user mods found to sort", new Object[0]);
            }
            throw throwable;
        }
        FMLLog.fine("Mod sorting data", new Object[0]);
        int unprintedMods = this.mods.size();
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.isImmutable()) continue;
            FMLLog.fine("\t%s(%s:%s): %s (%s)", mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), mod.getSortingRules());
            --unprintedMods;
        }
        if (unprintedMods == this.mods.size()) {
            FMLLog.fine("No user mods found to sort", new Object[0]);
        }
    }

    private ModDiscoverer identifyMods() {
        FMLLog.fine("Building injected Mod Containers %s", injectedContainers);
        this.mods.add(new InjectedModContainer(this.mcp, new File("minecraft.jar")));
        for (String cont : injectedContainers) {
            ModContainer mc;
            try {
                mc = (ModContainer)Class.forName(cont, true, this.modClassLoader).newInstance();
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "A problem occured instantiating the injected mod container %s", cont);
                throw new LoaderException(e);
            }
            this.mods.add(new InjectedModContainer(mc, mc.getSource()));
        }
        ModDiscoverer discoverer = new ModDiscoverer();
        FMLLog.fine("Attempting to load mods contained in the minecraft jar file and associated classes", new Object[0]);
        discoverer.findClasspathMods(this.modClassLoader);
        FMLLog.fine("Minecraft jar mods loaded successfully", new Object[0]);
        FMLLog.info("Searching %s for mods", this.canonicalModsDir.getAbsolutePath());
        discoverer.findModDirMods(this.canonicalModsDir);
        File versionSpecificModsDir = new File(this.canonicalModsDir, mccversion);
        if (versionSpecificModsDir.isDirectory()) {
            FMLLog.info("Also searching %s for mods", versionSpecificModsDir);
            discoverer.findModDirMods(versionSpecificModsDir);
        }
        this.mods.addAll(discoverer.identifyMods());
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex(this.mods, (Function)new ModIdFunction());
        FMLLog.info("Forge Mod Loader has identified %d mod%s to load", this.mods.size(), this.mods.size() != 1 ? "s" : "");
        return discoverer;
    }

    private void identifyDuplicates(List<ModContainer> mods) {
        TreeMultimap dupsearch = TreeMultimap.create((Comparator)new ModIdComparator(), (Comparator)Ordering.arbitrary());
        for (ModContainer mc : mods) {
            if (mc.getSource() == null) continue;
            dupsearch.put((Object)mc, (Object)mc.getSource());
        }
        ImmutableMultiset duplist = Multisets.copyHighestCountFirst((Multiset)dupsearch.keys());
        LinkedHashMultimap dupes = LinkedHashMultimap.create();
        for (Multiset.Entry e : duplist.entrySet()) {
            if (e.getCount() <= 1) continue;
            FMLLog.severe("Found a duplicate mod %s at %s", ((ModContainer)e.getElement()).getModId(), dupsearch.get(e.getElement()));
            dupes.putAll(e.getElement(), (Iterable)dupsearch.get(e.getElement()));
        }
        if (!dupes.isEmpty()) {
            throw new DuplicateModsFoundException((SetMultimap<ModContainer, File>)dupes);
        }
    }

    private void initializeLoader() {
        boolean dirMade;
        String canonicalConfigPath;
        String canonicalModsPath;
        File modsDir = new File(minecraftDir, "mods");
        File configDir = new File(minecraftDir, "config");
        try {
            canonicalModsPath = modsDir.getCanonicalPath();
            canonicalConfigPath = configDir.getCanonicalPath();
            this.canonicalConfigDir = configDir.getCanonicalFile();
            this.canonicalModsDir = modsDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            FMLLog.log(Level.ERROR, ioe, "Failed to resolve loader directories: mods : %s ; config %s", this.canonicalModsDir.getAbsolutePath(), configDir.getAbsolutePath());
            throw new LoaderException(ioe);
        }
        if (!this.canonicalModsDir.exists()) {
            FMLLog.info("No mod directory found, creating one: %s", canonicalModsPath);
            dirMade = this.canonicalModsDir.mkdir();
            if (!dirMade) {
                FMLLog.severe("Unable to create the mod directory %s", canonicalModsPath);
                throw new LoaderException();
            }
            FMLLog.info("Mod directory created successfully", new Object[0]);
        }
        if (!this.canonicalConfigDir.exists()) {
            FMLLog.fine("No config directory found, creating one: %s", canonicalConfigPath);
            dirMade = this.canonicalConfigDir.mkdir();
            if (!dirMade) {
                FMLLog.severe("Unable to create the config directory %s", canonicalConfigPath);
                throw new LoaderException();
            }
            FMLLog.info("Config directory created successfully", new Object[0]);
        }
        if (!this.canonicalModsDir.isDirectory()) {
            FMLLog.severe("Attempting to load mods from %s, which is not a directory", canonicalModsPath);
            throw new LoaderException();
        }
        if (!configDir.isDirectory()) {
            FMLLog.severe("Attempting to load configuration from %s, which is not a directory", canonicalConfigPath);
            throw new LoaderException();
        }
    }

    public List<ModContainer> getModList() {
        return Loader.instance().mods != null ? ImmutableList.copyOf(Loader.instance().mods) : ImmutableList.of();
    }

    public void loadMods() {
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = new LoadController(this);
        this.modController.transition(LoaderState.LOADING, false);
        this.discoverer = this.identifyMods();
        ModAPIManager.INSTANCE.manageAPI(this.modClassLoader, this.discoverer);
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.modController.getActiveModList());
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.mods);
        this.mods = ImmutableList.copyOf(this.mods);
        for (File nonMod : this.discoverer.getNonModLibs()) {
            if (!nonMod.isFile()) continue;
            FMLLog.info("FML has found a non-mod file %s in your mods directory. It will now be injected into your classpath. This could severe stability issues, it should be removed if possible.", nonMod.getName());
            try {
                this.modClassLoader.addFile(nonMod);
            }
            catch (MalformedURLException e) {
                FMLLog.log(Level.ERROR, e, "Encountered a weird problem with non-mod file injection : %s", nonMod.getName());
            }
        }
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, this.modClassLoader, this.discoverer.getASMTable(), this.reverseDependencies);
        FMLLog.fine("Mod signature data", new Object[0]);
        for (ModContainer mod : this.getActiveModList()) {
            FMLLog.fine("\t%s(%s:%s): %s (%s)", mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), CertificateHelper.getFingerprint(mod.getSigningCertificate()));
        }
        if (this.getActiveModList().isEmpty()) {
            FMLLog.fine("No user mod signature data found", new Object[0]);
        }
        this.modController.transition(LoaderState.PREINITIALIZATION, false);
    }

    public void preinitializeMods() {
        ObjectHolderRegistry.INSTANCE.findObjectHolders(this.discoverer.getASMTable());
        if (!this.modController.isInState(LoaderState.PREINITIALIZATION)) {
            FMLLog.warning("There were errors previously. Not beginning mod initialization phase", new Object[0]);
            return;
        }
        this.modController.distributeStateMessage(LoaderState.PREINITIALIZATION, this.discoverer.getASMTable(), this.canonicalConfigDir);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        this.modController.transition(LoaderState.INITIALIZATION, false);
    }

    private void disableRequestedMods() {
        String forcedModList = System.getProperty("fml.modStates", "");
        FMLLog.finer("Received a system property request '%s'", forcedModList);
        Map sysPropertyStateList = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)";:")).omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)forcedModList);
        FMLLog.finer("System property request managing the state of %d mods", sysPropertyStateList.size());
        HashMap modStates = Maps.newHashMap();
        this.forcedModFile = new File(this.canonicalConfigDir, "fmlModState.properties");
        Properties forcedModListProperties = new Properties();
        if (this.forcedModFile.exists() && this.forcedModFile.isFile()) {
            FMLLog.finer("Found a mod state file %s", this.forcedModFile.getName());
            try {
                forcedModListProperties.load(new FileReader(this.forcedModFile));
                FMLLog.finer("Loaded states for %d mods from file", forcedModListProperties.size());
            }
            catch (Exception e) {
                FMLLog.log(Level.INFO, e, "An error occurred reading the fmlModState.properties file", new Object[0]);
            }
        }
        modStates.putAll(Maps.fromProperties((Properties)forcedModListProperties));
        modStates.putAll(sysPropertyStateList);
        FMLLog.fine("After merging, found state information for %d mods", modStates.size());
        Map isEnabled = Maps.transformValues((Map)modStates, (Function)new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return Boolean.parseBoolean(input);
            }
        });
        for (Map.Entry entry : isEnabled.entrySet()) {
            if (!this.namedMods.containsKey(entry.getKey())) continue;
            FMLLog.info("Setting mod %s to enabled state %b", entry.getKey(), entry.getValue());
            this.namedMods.get(entry.getKey()).setEnabledState((Boolean)entry.getValue());
        }
    }

    public static boolean isModLoaded(String modname) {
        return Loader.instance().namedMods.containsKey(modname) && Loader.instance().modController.getModState(Loader.instance.namedMods.get(modname)) != LoaderState.ModState.DISABLED;
    }

    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    public String getCrashInformation() {
        if (this.modController == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        List<String> branding = FMLCommonHandler.instance().getBrandings(false);
        Joiner.on((char)' ').skipNulls().appendTo(ret, branding);
        if (this.modController != null) {
            this.modController.printModStates(ret);
        }
        return ret.toString();
    }

    public String getFMLVersionString() {
        return String.format("%s.%s.%s.%s", major, minor, rev, build);
    }

    public ClassLoader getModClassLoader() {
        return this.modClassLoader;
    }

    public void computeDependencies(String dependencyString, Set<ArtifactVersion> requirements, List<ArtifactVersion> dependencies, List<ArtifactVersion> dependants) {
        if (dependencyString == null || dependencyString.length() == 0) {
            return;
        }
        boolean parseFailure = false;
        for (String dep : DEPENDENCYSPLITTER.split((CharSequence)dependencyString)) {
            ArrayList depparts = Lists.newArrayList((Iterable)DEPENDENCYPARTSPLITTER.split((CharSequence)dep));
            if (depparts.size() != 2) {
                parseFailure = true;
                continue;
            }
            String instruction = (String)depparts.get(0);
            String target = (String)depparts.get(1);
            boolean targetIsAll = target.startsWith("*");
            if (targetIsAll && target.length() > 1) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(instruction) || "required-after".equals(instruction)) {
                if (!targetIsAll) {
                    requirements.add(VersionParser.parseVersionReference(target));
                } else {
                    parseFailure = true;
                    continue;
                }
            }
            if (targetIsAll && target.indexOf(64) > -1) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(instruction) || "before".equals(instruction)) {
                dependants.add(VersionParser.parseVersionReference(target));
                continue;
            }
            if ("required-after".equals(instruction) || "after".equals(instruction)) {
                dependencies.add(VersionParser.parseVersionReference(target));
                continue;
            }
            parseFailure = true;
        }
        if (parseFailure) {
            FMLLog.log(Level.WARN, "Unable to parse dependency string %s", dependencyString);
            throw new LoaderException();
        }
    }

    public Map<String, ModContainer> getIndexedModList() {
        return ImmutableMap.copyOf(this.namedMods);
    }

    public void initializeMods() {
        this.modController.distributeStateMessage(LoaderState.INITIALIZATION, new Object[0]);
        this.modController.transition(LoaderState.POSTINITIALIZATION, false);
        this.modController.distributeStateMessage(FMLInterModComms.IMCEvent.class);
        this.modController.distributeStateMessage(LoaderState.POSTINITIALIZATION, new Object[0]);
        this.modController.transition(LoaderState.AVAILABLE, false);
        this.modController.distributeStateMessage(LoaderState.AVAILABLE, new Object[0]);
        GameData.freezeData();
        GameData.dumpRegistry(minecraftDir);
        FMLLog.info("Forge Mod Loader has successfully loaded %d mod%s", this.mods.size(), this.mods.size() == 1 ? "" : "s");
    }

    public ICrashCallable getCallableCrashInformation() {
        return new ICrashCallable(){

            @Override
            public String call() throws Exception {
                return Loader.this.getCrashInformation();
            }

            @Override
            public String getLabel() {
                return "FML";
            }
        };
    }

    public List<ModContainer> getActiveModList() {
        return this.modController != null ? this.modController.getActiveModList() : ImmutableList.of();
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return this.modController.getModState(selectedMod);
    }

    public String getMCVersionString() {
        return "Minecraft " + mccversion;
    }

    public boolean serverStarting(Object server) {
        try {
            this.modController.distributeStateMessage(LoaderState.SERVER_STARTING, server);
            this.modController.transition(LoaderState.SERVER_STARTING, false);
        }
        catch (Throwable t) {
            FMLLog.log(Level.ERROR, t, "A fatal exception occurred during the server starting event", new Object[0]);
            return false;
        }
        return true;
    }

    public void serverStarted() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STARTED, false);
    }

    public void serverStopping() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPING, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPING, false);
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        return this.modController.getModObjectList();
    }

    public BiMap<Object, ModContainer> getReversedModObjectList() {
        return this.getModObjectList().inverse();
    }

    public ModContainer activeModContainer() {
        return this.modController != null ? this.modController.activeContainer() : null;
    }

    public boolean isInState(LoaderState state) {
        return this.modController.isInState(state);
    }

    public MinecraftDummyContainer getMinecraftModContainer() {
        return this.minecraft;
    }

    public boolean hasReachedState(LoaderState state) {
        return this.modController != null ? this.modController.hasReachedState(state) : false;
    }

    public String getMCPVersionString() {
        return String.format("MCP v%s", mcpversion);
    }

    public void serverStopped() {
        GameData.revertToFrozen();
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPED, true);
        this.modController.transition(LoaderState.AVAILABLE, true);
    }

    public boolean serverAboutToStart(Object server) {
        try {
            this.modController.distributeStateMessage(LoaderState.SERVER_ABOUT_TO_START, server);
            this.modController.transition(LoaderState.SERVER_ABOUT_TO_START, false);
        }
        catch (Throwable t) {
            FMLLog.log(Level.ERROR, t, "A fatal exception occurred during the server about to start event", new Object[0]);
            return false;
        }
        return true;
    }

    public Map<String, String> getFMLBrandingProperties() {
        if (this.fmlBrandingProperties == null) {
            Properties loaded = new Properties();
            try {
                loaded.load(this.getClass().getClassLoader().getResourceAsStream("fmlbranding.properties"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fmlBrandingProperties = Maps.fromProperties((Properties)loaded);
        }
        return this.fmlBrandingProperties;
    }

    public Map<String, String> getCustomModProperties(String modId) {
        return this.getIndexedModList().get(modId).getCustomModProperties();
    }

    boolean checkRemoteModList(Map<String, String> modList, Side side) {
        Set<String> remoteModIds = modList.keySet();
        Set<String> localModIds = this.namedMods.keySet();
        LinkedHashSet difference = Sets.newLinkedHashSet((Iterable)Sets.difference(localModIds, remoteModIds));
        Iterator iterator = difference.iterator();
        while (iterator.hasNext()) {
            String missingRemotely = (String)iterator.next();
            LoaderState.ModState modState = this.modController.getModState(this.namedMods.get(missingRemotely));
            if (modState != LoaderState.ModState.DISABLED) continue;
            iterator.remove();
        }
        FMLLog.info("Attempting connection with missing mods %s at %s", new Object[]{difference, side});
        return true;
    }

    public List<String> fireMissingMappingEvent(LinkedHashMap<String, Integer> missing, boolean isLocalWorld, GameData gameData, Map<String, Integer[]> remaps) {
        if (missing.isEmpty()) {
            return ImmutableList.of();
        }
        FMLLog.fine("There are %d mappings missing - attempting a mod remap", missing.size());
        ArrayListMultimap missingMappings = ArrayListMultimap.create();
        for (Map.Entry<String, Integer> mapping : missing.entrySet()) {
            int id = mapping.getValue();
            FMLMissingMappingsEvent.MissingMapping m = new FMLMissingMappingsEvent.MissingMapping(mapping.getKey(), id);
            missingMappings.put((Object)m.name.substring(0, m.name.indexOf(58)), (Object)m);
        }
        FMLMissingMappingsEvent missingEvent = new FMLMissingMappingsEvent((ListMultimap<String, FMLMissingMappingsEvent.MissingMapping>)missingMappings);
        this.modController.propogateStateMessage(missingEvent);
        if (isLocalWorld) {
            boolean didWarn = false;
            for (FMLMissingMappingsEvent.MissingMapping mapping : missingMappings.values()) {
                if (mapping.getAction() != FMLMissingMappingsEvent.Action.DEFAULT) continue;
                if (!didWarn) {
                    FMLLog.severe("There are unidentified mappings in this world - we are going to attempt to process anyway", new Object[0]);
                    didWarn = true;
                }
                FMLLog.severe("Unidentified %s: %s, id %d", mapping.type == GameRegistry.Type.BLOCK ? "block" : "item", mapping.name, mapping.id);
            }
        } else {
            ArrayList<String> missedMapping = new ArrayList<String>();
            for (FMLMissingMappingsEvent.MissingMapping mapping : missingMappings.values()) {
                if (mapping.getAction() != FMLMissingMappingsEvent.Action.DEFAULT) continue;
                missedMapping.add(mapping.name);
            }
            if (!missedMapping.isEmpty()) {
                return ImmutableList.copyOf(missedMapping);
            }
        }
        return GameData.processIdRematches(missingMappings.values(), isLocalWorld, gameData, remaps);
    }

    public void fireRemapEvent(Map<String, Integer[]> remaps) {
        if (remaps.isEmpty()) {
            FMLLog.finer("Skipping remap event - no remaps occured", new Object[0]);
        } else {
            this.modController.propogateStateMessage(new FMLModIdMappingEvent(remaps));
        }
    }

    public void runtimeDisableMod(String modId) {
        ModContainer mc = this.namedMods.get(modId);
        ModContainer.Disableable disableable = mc.canBeDisabled();
        if (disableable == ModContainer.Disableable.NEVER) {
            FMLLog.info("Cannot disable mod %s - it is never allowed to be disabled", modId);
            return;
        }
        if (disableable == ModContainer.Disableable.DEPENDENCIES) {
            FMLLog.info("Cannot disable mod %s - there are dependent mods that require its presence", modId);
            return;
        }
        if (disableable == ModContainer.Disableable.YES) {
            FMLLog.info("Runtime disabling mod %s", modId);
            this.modController.disableMod(mc);
            ArrayList localmods = Lists.newArrayList(this.mods);
            localmods.remove(mc);
            this.mods = ImmutableList.copyOf((Collection)localmods);
        }
        try {
            Properties props = new Properties();
            props.load(new FileReader(this.forcedModFile));
            props.put(modId, "false");
            props.store(new FileWriter(this.forcedModFile), null);
        }
        catch (Exception e) {
            FMLLog.log(Level.INFO, e, "An error occurred writing the fml mod states file, your disabled change won't persist", new Object[0]);
        }
    }

    private class ModIdComparator
    implements Comparator<ModContainer> {
        private ModIdComparator() {
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            return o1.getModId().compareTo(o2.getModId());
        }
    }
}

