/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemFluidContainer
extends yc
implements IFluidContainerItem {
    protected int capacity;

    public ItemFluidContainer(int itemID) {
        super(itemID);
    }

    public ItemFluidContainer(int itemID, int capacity) {
        super(itemID);
        this.capacity = capacity;
    }

    public ItemFluidContainer setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public FluidStack getFluid(ye container) {
        if (container.e == null || !container.e.b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT(container.e.l("Fluid"));
    }

    @Override
    public int getCapacity(ye container) {
        return this.capacity;
    }

    @Override
    public int fill(ye container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.e == null || !container.e.b("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT(container.e.l("Fluid"));
            if (stack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.e == null) {
            container.e = new by();
        }
        if (!container.e.b("Fluid")) {
            by fluidTag = resource.writeToNBT(new by());
            if (this.capacity < resource.amount) {
                fluidTag.a("Amount", this.capacity);
                container.e.a("Fluid", (cl)fluidTag);
                return this.capacity;
            }
            container.e.a("Fluid", (cl)fluidTag);
            return resource.amount;
        }
        by fluidTag = container.e.l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT(fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.e.a("Fluid", (cl)stack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public FluidStack drain(ye container, int maxDrain, boolean doDrain) {
        if (container.e == null || !container.e.b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT(container.e.l("Fluid"));
        if (stack == null) {
            return null;
        }
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (maxDrain >= this.capacity) {
                container.e.o("Fluid");
                if (container.e.d()) {
                    container.e = null;
                }
                return stack;
            }
            by fluidTag = container.e.l("Fluid");
            fluidTag.a("Amount", fluidTag.e("Amount") - maxDrain);
            container.e.a("Fluid", (cl)fluidTag);
        }
        return stack;
    }
}

