/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.ObjectInputStream;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.time.FastDateFormat$1;
import org.apache.commons.lang3.time.FastDateFormat$CharacterLiteral;
import org.apache.commons.lang3.time.FastDateFormat$NumberRule;
import org.apache.commons.lang3.time.FastDateFormat$PaddedNumberField;
import org.apache.commons.lang3.time.FastDateFormat$Rule;
import org.apache.commons.lang3.time.FastDateFormat$StringLiteral;
import org.apache.commons.lang3.time.FastDateFormat$TextField;
import org.apache.commons.lang3.time.FastDateFormat$TimeZoneDisplayKey;
import org.apache.commons.lang3.time.FastDateFormat$TimeZoneNameRule;
import org.apache.commons.lang3.time.FastDateFormat$TimeZoneNumberRule;
import org.apache.commons.lang3.time.FastDateFormat$TwelveHourField;
import org.apache.commons.lang3.time.FastDateFormat$TwentyFourHourField;
import org.apache.commons.lang3.time.FastDateFormat$TwoDigitMonthField;
import org.apache.commons.lang3.time.FastDateFormat$TwoDigitNumberField;
import org.apache.commons.lang3.time.FastDateFormat$TwoDigitYearField;
import org.apache.commons.lang3.time.FastDateFormat$UnpaddedMonthField;
import org.apache.commons.lang3.time.FastDateFormat$UnpaddedNumberField;
import org.apache.commons.lang3.time.FormatCache;

public class FastDateFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static final FormatCache<FastDateFormat> cache = new FastDateFormat$1();
    private static ConcurrentMap<FastDateFormat$TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<FastDateFormat$TimeZoneDisplayKey, String>(7);
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient FastDateFormat$Rule[] mRules;
    private transient int mMaxLengthEstimate;

    public static FastDateFormat getInstance() {
        return cache.getDateTimeInstance(3, 3, null, null);
    }

    public static FastDateFormat getInstance(String string) {
        return cache.getInstance(string, null, null);
    }

    public static FastDateFormat getInstance(String string, TimeZone timeZone) {
        return cache.getInstance(string, timeZone, null);
    }

    public static FastDateFormat getInstance(String string, Locale locale) {
        return cache.getInstance(string, null, locale);
    }

    public static FastDateFormat getInstance(String string, TimeZone timeZone, Locale locale) {
        return cache.getInstance(string, timeZone, locale);
    }

    public static FastDateFormat getDateInstance(int n2) {
        return cache.getDateTimeInstance(n2, null, null, null);
    }

    public static FastDateFormat getDateInstance(int n2, Locale locale) {
        return cache.getDateTimeInstance(n2, null, null, locale);
    }

    public static FastDateFormat getDateInstance(int n2, TimeZone timeZone) {
        return cache.getDateTimeInstance(n2, null, timeZone, null);
    }

    public static FastDateFormat getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        return cache.getDateTimeInstance(n2, null, timeZone, locale);
    }

    public static FastDateFormat getTimeInstance(int n2) {
        return cache.getDateTimeInstance(null, n2, null, null);
    }

    public static FastDateFormat getTimeInstance(int n2, Locale locale) {
        return cache.getDateTimeInstance(null, n2, null, locale);
    }

    public static FastDateFormat getTimeInstance(int n2, TimeZone timeZone) {
        return cache.getDateTimeInstance(null, n2, timeZone, null);
    }

    public static FastDateFormat getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        return cache.getDateTimeInstance(null, n2, timeZone, locale);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3) {
        return cache.getDateTimeInstance(n2, n3, null, null);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, Locale locale) {
        return cache.getDateTimeInstance(n2, n3, null, locale);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, TimeZone timeZone) {
        return FastDateFormat.getDateTimeInstance(n2, n3, timeZone, null);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        return cache.getDateTimeInstance(n2, n3, timeZone, locale);
    }

    static String a(TimeZone object, boolean bl, int n2, Locale locale) {
        FastDateFormat$TimeZoneDisplayKey fastDateFormat$TimeZoneDisplayKey = new FastDateFormat$TimeZoneDisplayKey((TimeZone)object, bl, n2, locale);
        Object object2 = (String)cTimeZoneDisplayCache.get(fastDateFormat$TimeZoneDisplayKey);
        if (object2 == null && (object = cTimeZoneDisplayCache.putIfAbsent(fastDateFormat$TimeZoneDisplayKey, (String)(object2 = ((TimeZone)object).getDisplayName(bl, n2, locale)))) != null) {
            object2 = object;
        }
        return object2;
    }

    protected FastDateFormat(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<FastDateFormat$Rule> list = this.parsePattern();
        this.mRules = list.toArray(new FastDateFormat$Rule[list.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected List<FastDateFormat$Rule> parsePattern() {
        String[] stringArray = new DateFormatSymbols(this.mLocale);
        ArrayList<FastDateFormat$Rule> arrayList = new ArrayList<FastDateFormat$Rule>();
        String[] stringArray2 = stringArray.getEras();
        String[] stringArray3 = stringArray.getMonths();
        String[] stringArray4 = stringArray.getShortMonths();
        String[] stringArray5 = stringArray.getWeekdays();
        String[] stringArray6 = stringArray.getShortWeekdays();
        stringArray = stringArray.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[0] = i2;
            Object object = this.parseToken(this.mPattern, nArray);
            i2 = nArray[0];
            int n3 = ((String)object).length();
            if (n3 == 0) break;
            char c2 = ((String)object).charAt(0);
            switch (c2) {
                case 'G': {
                    object = new FastDateFormat$TextField(0, stringArray2);
                    break;
                }
                case 'y': {
                    if (n3 == 2) {
                        object = FastDateFormat$TwoDigitYearField.a;
                        break;
                    }
                    object = this.selectNumberRule(1, n3 < 4 ? 4 : n3);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        object = new FastDateFormat$TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 3) {
                        object = new FastDateFormat$TextField(2, stringArray4);
                        break;
                    }
                    if (n3 == 2) {
                        object = FastDateFormat$TwoDigitMonthField.a;
                        break;
                    }
                    object = FastDateFormat$UnpaddedMonthField.a;
                    break;
                }
                case 'd': {
                    object = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    object = new FastDateFormat$TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    object = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    object = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    object = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    object = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    object = new FastDateFormat$TextField(7, n3 < 4 ? stringArray6 : stringArray5);
                    break;
                }
                case 'D': {
                    object = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    object = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    object = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    object = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    object = new FastDateFormat$TextField(9, stringArray);
                    break;
                }
                case 'k': {
                    object = new FastDateFormat$TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    object = this.selectNumberRule(10, n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        object = new FastDateFormat$TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    object = new FastDateFormat$TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        object = FastDateFormat$TimeZoneNumberRule.b;
                        break;
                    }
                    object = FastDateFormat$TimeZoneNumberRule.a;
                    break;
                }
                case '\'': {
                    object = ((String)object).substring(1);
                    if (((String)object).length() == 1) {
                        object = new FastDateFormat$CharacterLiteral(((String)object).charAt(0));
                        break;
                    }
                    object = new FastDateFormat$StringLiteral((String)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + (String)object);
                }
            }
            arrayList.add((FastDateFormat$Rule)object);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    protected FastDateFormat$NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new FastDateFormat$UnpaddedNumberField(n2);
            }
            case 2: {
                return new FastDateFormat$TwoDigitNumberField(n2);
            }
        }
        return new FastDateFormat$PaddedNumberField(n2, n3);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    public String format(long l2) {
        return this.format(new Date(l2));
    }

    public String format(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mTimeZone, this.mLocale);
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        return this.format(new Date(l2), stringBuffer);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mTimeZone, this.mLocale);
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, stringBuffer);
    }

    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, stringBuffer);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        FastDateFormat$Rule[] fastDateFormat$RuleArray = this.mRules;
        int n2 = this.mRules.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FastDateFormat$Rule fastDateFormat$Rule = fastDateFormat$RuleArray[i2];
            fastDateFormat$Rule.appendTo(stringBuffer, calendar);
        }
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        parsePosition.setIndex(0);
        parsePosition.setErrorIndex(0);
        return null;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FastDateFormat)) {
            return false;
        }
        object = (FastDateFormat)object;
        return this.mPattern.equals(((FastDateFormat)object).mPattern) && this.mTimeZone.equals(((FastDateFormat)object).mTimeZone) && this.mLocale.equals(((FastDateFormat)object).mLocale);
    }

    public final int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public final String toString() {
        return "FastDateFormat[" + this.mPattern + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }
}

