/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.lang3.text.translate.AggregateTranslator;

public abstract class CharSequenceTranslator {
    public abstract int translate(CharSequence var1, int var2, Writer var3);

    public final String translate(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(charSequence.length() << 1);
            this.translate(charSequence, stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public final void translate(CharSequence charSequence, Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (charSequence == null) {
            return;
        }
        int n2 = 0;
        int n3 = charSequence.length();
        while (n2 < n3) {
            int n4 = this.translate(charSequence, n2, writer);
            if (n4 == 0) {
                char[] cArray = Character.toChars(Character.codePointAt(charSequence, n2));
                writer.write(cArray);
                n2 += cArray.length;
                continue;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                n2 += Character.charCount(Character.codePointAt(charSequence, n2));
            }
        }
    }

    public final CharSequenceTranslator with(CharSequenceTranslator ... charSequenceTranslatorArray) {
        CharSequenceTranslator[] charSequenceTranslatorArray2 = new CharSequenceTranslator[charSequenceTranslatorArray.length + 1];
        CharSequenceTranslator[] charSequenceTranslatorArray3 = charSequenceTranslatorArray2;
        charSequenceTranslatorArray2[0] = this;
        System.arraycopy(charSequenceTranslatorArray, 0, charSequenceTranslatorArray3, 1, charSequenceTranslatorArray.length);
        return new AggregateTranslator(charSequenceTranslatorArray3);
    }

    public static String hex(int n2) {
        return Integer.toHexString(n2).toUpperCase(Locale.ENGLISH);
    }
}

