/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class WordUtils {
    public static String wrap(String string, int n2) {
        return WordUtils.wrap(string, n2, null, false);
    }

    public static String wrap(String string, int n2, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = SystemUtils.LINE_SEPARATOR;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        int n3 = string.length();
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(n3 + 32);
        while (n3 - n4 > n2) {
            if (string.charAt(n4) == ' ') {
                ++n4;
                continue;
            }
            int n5 = string.lastIndexOf(32, n2 + n4);
            if (n5 >= n4) {
                stringBuilder.append(string.substring(n4, n5));
                stringBuilder.append(string2);
                n4 = n5 + 1;
                continue;
            }
            if (bl) {
                stringBuilder.append(string.substring(n4, n2 + n4));
                stringBuilder.append(string2);
                n4 += n2;
                continue;
            }
            n5 = string.indexOf(32, n2 + n4);
            if (n5 >= 0) {
                stringBuilder.append(string.substring(n4, n5));
                stringBuilder.append(string2);
                n4 = n5 + 1;
                continue;
            }
            stringBuilder.append(string.substring(n4));
            n4 = n3;
        }
        stringBuilder.append(string.substring(n4));
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        return WordUtils.capitalize(string, null);
    }

    public static String capitalize(String object, char ... cArray) {
        int n2;
        int n3 = n2 = cArray == null ? -1 : cArray.length;
        if (StringUtils.isEmpty((CharSequence)object) || n2 == 0) {
            return object;
        }
        object = ((String)object).toCharArray();
        n2 = 1;
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            if (WordUtils.isDelimiter((char)object2, cArray)) {
                n2 = 1;
                continue;
            }
            if (n2 == 0) continue;
            object[i2] = Character.toTitleCase((char)object2);
            n2 = 0;
        }
        return new String((char[])object);
    }

    public static String capitalizeFully(String string) {
        return WordUtils.capitalizeFully(string, null);
    }

    public static String capitalizeFully(String string, char ... cArray) {
        int n2;
        int n3 = n2 = cArray == null ? -1 : cArray.length;
        if (StringUtils.isEmpty(string) || n2 == 0) {
            return string;
        }
        string = string.toLowerCase();
        return WordUtils.capitalize(string, cArray);
    }

    public static String uncapitalize(String string) {
        return WordUtils.uncapitalize(string, null);
    }

    public static String uncapitalize(String object, char ... cArray) {
        int n2;
        int n3 = n2 = cArray == null ? -1 : cArray.length;
        if (StringUtils.isEmpty((CharSequence)object) || n2 == 0) {
            return object;
        }
        object = ((String)object).toCharArray();
        n2 = 1;
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            if (WordUtils.isDelimiter((char)object2, cArray)) {
                n2 = 1;
                continue;
            }
            if (n2 == 0) continue;
            object[i2] = Character.toLowerCase((char)object2);
            n2 = 0;
        }
        return new String((char[])object);
    }

    public static String swapCase(String object) {
        if (StringUtils.isEmpty((CharSequence)object)) {
            return object;
        }
        object = ((String)object).toCharArray();
        boolean bl = true;
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            Object object2 = object[i2];
            if (Character.isUpperCase((char)object2)) {
                object[i2] = Character.toLowerCase((char)object2);
                bl = false;
                continue;
            }
            if (Character.isTitleCase((char)object2)) {
                object[i2] = Character.toLowerCase((char)object2);
                bl = false;
                continue;
            }
            if (Character.isLowerCase((char)object2)) {
                if (bl) {
                    object[i2] = Character.toTitleCase((char)object2);
                    bl = false;
                    continue;
                }
                object[i2] = Character.toUpperCase((char)object2);
                continue;
            }
            bl = Character.isWhitespace((char)object2);
        }
        return new String((char[])object);
    }

    public static String initials(String string) {
        return WordUtils.initials(string, null);
    }

    public static String initials(String string, char ... cArray) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (cArray != null && cArray.length == 0) {
            return "";
        }
        int n2 = string.length();
        char[] cArray2 = new char[n2 / 2 + 1];
        int n3 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (WordUtils.isDelimiter(c2, cArray)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            cArray2[n3++] = c2;
            bl = false;
        }
        return new String(cArray2, 0, n3);
    }

    private static boolean isDelimiter(char c2, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(c2);
        }
        for (char c3 : cArray) {
            if (c2 != c3) continue;
            return true;
        }
        return false;
    }
}

