/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.commons.lang3.text.StrMatcher;

public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "";
    private static final String ESCAPED_QUOTE = "''";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;

    public ExtendedMessageFormat(String string) {
        this(string, Locale.getDefault());
    }

    public ExtendedMessageFormat(String string, Locale locale) {
        this(string, locale, null);
    }

    public ExtendedMessageFormat(String string, Map<String, ? extends FormatFactory> map) {
        this(string, Locale.getDefault(), map);
    }

    public ExtendedMessageFormat(String string, Locale locale, Map<String, ? extends FormatFactory> map) {
        super(DUMMY_PATTERN);
        this.setLocale(locale);
        this.registry = map;
        this.applyPattern(string);
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyPattern(String string) {
        int n2;
        if (this.registry == null) {
            super.applyPattern(string);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        ParsePosition parsePosition = new ParsePosition(0);
        char[] cArray = string.toCharArray();
        int n3 = 0;
        block4: while (parsePosition.getIndex() < string.length()) {
            switch (cArray[parsePosition.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(string, parsePosition, stringBuilder, true);
                    continue block4;
                }
                case '{': {
                    void object2;
                    String string2;
                    ++n3;
                    this.seekNonWs(string, parsePosition);
                    int n4 = parsePosition.getIndex();
                    n2 = this.readArgumentIndex(string, this.next(parsePosition));
                    stringBuilder.append('{').append(n2);
                    this.seekNonWs(string, parsePosition);
                    Object object = null;
                    Object var11_13 = null;
                    if (cArray[parsePosition.getIndex()] == ',' && (object = this.getFormat(string2 = this.parseFormatDescription(string, this.next(parsePosition)))) == null) {
                        stringBuilder.append(',').append(string2);
                    }
                    arrayList.add(object);
                    arrayList2.add((String)(object == null ? null : object2));
                    Validate.isTrue(arrayList.size() == n3);
                    Validate.isTrue(arrayList2.size() == n3);
                    if (cArray[parsePosition.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + n4);
                }
            }
            stringBuilder.append(cArray[parsePosition.getIndex()]);
            this.next(parsePosition);
        }
        super.applyPattern(stringBuilder.toString());
        this.toPattern = this.insertFormats(super.toPattern(), arrayList2);
        if (this.containsElements(arrayList)) {
            Format[] formatArray = this.getFormats();
            n2 = 0;
            for (Format format : arrayList) {
                if (format != null) {
                    formatArray[n2] = format;
                }
                ++n2;
            }
            super.setFormats(formatArray);
        }
    }

    @Override
    public void setFormat(int n2, Format format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int n2, Format format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] formatArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] formatArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (ObjectUtils.notEqual(this.getClass(), object.getClass())) {
            return false;
        }
        object = (ExtendedMessageFormat)object;
        if (ObjectUtils.notEqual(this.toPattern, ((ExtendedMessageFormat)object).toPattern)) {
            return false;
        }
        return !ObjectUtils.notEqual(this.registry, ((ExtendedMessageFormat)object).registry);
    }

    @Override
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + ObjectUtils.hashCode(this.registry);
        n2 = n2 * 31 + ObjectUtils.hashCode(this.toPattern);
        return n2;
    }

    private Format getFormat(String object) {
        if (this.registry != null) {
            String string = object;
            String string2 = null;
            int n2 = ((String)object).indexOf(44);
            if (n2 > 0) {
                string = ((String)object).substring(0, n2).trim();
                string2 = ((String)object).substring(n2 + 1).trim();
            }
            if ((object = this.registry.get(string)) != null) {
                return object.getFormat(string, string2, this.getLocale());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String var1_1, ParsePosition var2_2) {
        var3_3 = var2_2.getIndex();
        this.seekNonWs(var1_1, var2_2);
        var4_4 = new StringBuffer();
        var5_5 = false;
        while (!var5_5 && var2_2.getIndex() < var1_1.length()) {
            var6_6 = var1_1.charAt(var2_2.getIndex());
            if (!Character.isWhitespace(var6_6)) ** GOTO lbl-1000
            this.seekNonWs(var1_1, var2_2);
            var6_6 = var1_1.charAt(var2_2.getIndex());
            if (var6_6 != ',' && var6_6 != '}') {
                var5_5 = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((var6_6 == ',' || var6_6 == '}') && var4_4.length() > 0) {
                    try {
                        return Integer.parseInt(var4_4.toString());
                    }
                    catch (NumberFormatException v0) {}
                }
                var5_5 = Character.isDigit(var6_6) == false;
                var4_4.append(var6_6);
            }
            this.next(var2_2);
        }
        if (var5_5) {
            throw new IllegalArgumentException("Invalid format argument index at position " + var3_3 + ": " + var1_1.substring(var3_3, var2_2.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + var3_3);
    }

    private String parseFormatDescription(String string, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        this.seekNonWs(string, parsePosition);
        int n3 = parsePosition.getIndex();
        int n4 = 1;
        while (parsePosition.getIndex() < string.length()) {
            switch (string.charAt(parsePosition.getIndex())) {
                case '{': {
                    ++n4;
                    break;
                }
                case '}': {
                    if (--n4 != 0) break;
                    return string.substring(n3, parsePosition.getIndex());
                }
                case '\'': {
                    this.getQuotedString(string, parsePosition, false);
                }
            }
            this.next(parsePosition);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + n2);
    }

    private String insertFormats(String string, ArrayList<String> arrayList) {
        if (!this.containsElements(arrayList)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() << 1);
        ParsePosition parsePosition = new ParsePosition(0);
        int n2 = -1;
        int n3 = 0;
        block5: while (parsePosition.getIndex() < string.length()) {
            char c2 = string.charAt(parsePosition.getIndex());
            switch (c2) {
                case '\'': {
                    this.appendQuotedString(string, parsePosition, stringBuilder, false);
                    continue block5;
                }
                case '{': {
                    String string2;
                    if (++n3 != 1) continue block5;
                    stringBuilder.append('{').append(this.readArgumentIndex(string, this.next(parsePosition)));
                    if ((string2 = arrayList.get(++n2)) == null) continue block5;
                    stringBuilder.append(',').append(string2);
                    continue block5;
                }
                case '}': {
                    --n3;
                }
            }
            stringBuilder.append(c2);
            this.next(parsePosition);
        }
        return stringBuilder.toString();
    }

    private void seekNonWs(String string, ParsePosition parsePosition) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        do {
            n2 = StrMatcher.splitMatcher().isMatch(cArray, parsePosition.getIndex());
            parsePosition.setIndex(parsePosition.getIndex() + n2);
        } while (n2 > 0 && parsePosition.getIndex() < string.length());
    }

    private ParsePosition next(ParsePosition parsePosition) {
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        return parsePosition;
    }

    private StringBuilder appendQuotedString(String string, ParsePosition parsePosition, StringBuilder stringBuilder, boolean bl) {
        int n2 = parsePosition.getIndex();
        char[] cArray = string.toCharArray();
        if (bl && cArray[n2] == '\'') {
            this.next(parsePosition);
            if (stringBuilder == null) {
                return null;
            }
            return stringBuilder.append('\'');
        }
        int n3 = n2;
        for (int i2 = parsePosition.getIndex(); i2 < string.length(); ++i2) {
            if (bl && string.substring(i2).startsWith(ESCAPED_QUOTE)) {
                stringBuilder.append(cArray, n3, parsePosition.getIndex() - n3).append('\'');
                parsePosition.setIndex(i2 + ESCAPED_QUOTE.length());
                n3 = parsePosition.getIndex();
                continue;
            }
            switch (cArray[parsePosition.getIndex()]) {
                case '\'': {
                    this.next(parsePosition);
                    if (stringBuilder == null) {
                        return null;
                    }
                    return stringBuilder.append(cArray, n3, parsePosition.getIndex() - n3);
                }
            }
            this.next(parsePosition);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + n2);
    }

    private void getQuotedString(String string, ParsePosition parsePosition, boolean bl) {
        this.appendQuotedString(string, parsePosition, null, bl);
    }

    private boolean containsElements(Collection<?> object) {
        if (object == null || object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 == null) continue;
            return true;
        }
        return false;
    }
}

