/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;

abstract class MemberUtils {
    private static final int ACCESS_TEST = 7;
    private static final Class<?>[] ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    MemberUtils() {
    }

    static void a(AccessibleObject accessibleObject) {
        int n2;
        if (accessibleObject == null || accessibleObject.isAccessible()) {
            return;
        }
        Member member = (Member)((Object)accessibleObject);
        if (Modifier.isPublic(member.getModifiers()) && ((n2 = member.getDeclaringClass().getModifiers()) & 7) == 0) {
            try {
                accessibleObject.setAccessible(true);
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    private static boolean isPackageAccess(int n2) {
        return (n2 & 7) == 0;
    }

    static boolean a(Member member) {
        return member != null && Modifier.isPublic(member.getModifiers()) && !member.isSynthetic();
    }

    static int a(Class<?>[] classArray, Class<?>[] classArray2, Class<?>[] classArray3) {
        float f2;
        float f3 = MemberUtils.getTotalTransformationCost(classArray3, classArray);
        if (f3 < (f2 = MemberUtils.getTotalTransformationCost(classArray3, classArray2))) {
            return -1;
        }
        if (f2 < f3) {
            return 1;
        }
        return 0;
    }

    private static float getTotalTransformationCost(Class<?>[] classArray, Class<?>[] classArray2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz = classArray[i2];
            Class<?> clazz2 = classArray2[i2];
            f2 += MemberUtils.getObjectTransformationCost(clazz, clazz2);
        }
        return f2;
    }

    private static float getObjectTransformationCost(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isPrimitive()) {
            return MemberUtils.getPrimitivePromotionCost(clazz, clazz2);
        }
        float f2 = 0.0f;
        while (clazz != null && !clazz2.equals(clazz)) {
            if (clazz2.isInterface() && ClassUtils.isAssignable(clazz, clazz2)) {
                f2 += 0.25f;
                break;
            }
            f2 += 1.0f;
            clazz = clazz.getSuperclass();
        }
        if (clazz == null) {
            f2 += 1.5f;
        }
        return f2;
    }

    private static float getPrimitivePromotionCost(Class<?> clazz, Class<?> clazz2) {
        float f2 = 0.0f;
        if (!clazz.isPrimitive()) {
            f2 = 0.1f;
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        for (int i2 = 0; clazz != clazz2 && i2 < ORDERED_PRIMITIVE_TYPES.length; ++i2) {
            if (clazz != ORDERED_PRIMITIVE_TYPES[i2]) continue;
            f2 += 0.1f;
            if (i2 >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
            clazz = ORDERED_PRIMITIVE_TYPES[i2 + 1];
        }
        return f2;
    }
}

