/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MemberUtils;

public class FieldUtils {
    public static Field getField(Class<?> annotatedElement, String string) {
        annotatedElement = FieldUtils.getField(annotatedElement, string, false);
        MemberUtils.a((AccessibleObject)annotatedElement);
        return annotatedElement;
    }

    public static Field getField(Class<?> annotatedElement, String string, boolean bl) {
        AnnotatedElement annotatedElement2;
        if (annotatedElement == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        for (annotatedElement2 = annotatedElement; annotatedElement2 != null; annotatedElement2 = annotatedElement2.getSuperclass()) {
            try {
                Field noSuchFieldException = annotatedElement2.getDeclaredField(string);
                if (!Modifier.isPublic(noSuchFieldException.getModifiers())) {
                    if (!bl) continue;
                    noSuchFieldException.setAccessible(true);
                }
                return noSuchFieldException;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        annotatedElement2 = null;
        for (Class annotatedElement3 : ClassUtils.getAllInterfaces(annotatedElement)) {
            try {
                Field noSuchFieldException = annotatedElement3.getField(string);
                if (annotatedElement2 != null) {
                    throw new IllegalArgumentException("Reference to field " + string + " is ambiguous relative to " + annotatedElement + "; a matching field exists on two or more implemented interfaces.");
                }
                annotatedElement2 = noSuchFieldException;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return annotatedElement2;
    }

    public static Field getDeclaredField(Class<?> clazz, String string) {
        return FieldUtils.getDeclaredField(clazz, string, false);
    }

    public static Field getDeclaredField(Class<?> annotatedElement, String string, boolean bl) {
        if (annotatedElement == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        try {
            annotatedElement = ((Class)annotatedElement).getDeclaredField(string);
            if (!MemberUtils.a((Member)((Object)annotatedElement))) {
                if (bl) {
                    ((Field)annotatedElement).setAccessible(true);
                } else {
                    return null;
                }
            }
            return annotatedElement;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Object readStaticField(Field field) {
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readStaticField(Field field, boolean bl) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        return FieldUtils.readField(field, null, bl);
    }

    public static Object readStaticField(Class<?> clazz, String string) {
        return FieldUtils.readStaticField(clazz, string, false);
    }

    public static Object readStaticField(Class<?> clazz, String string, boolean bl) {
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate field " + string + " on " + clazz);
        }
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string) {
        return FieldUtils.readDeclaredStaticField(clazz, string, false);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string, boolean bl) {
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readField(Field field, Object object) {
        return FieldUtils.readField(field, object, false);
    }

    public static Object readField(Field field, Object object, boolean bl) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (bl && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.a(field);
        }
        return field.get(object);
    }

    public static Object readField(Object object, String string) {
        return FieldUtils.readField(object, string, false);
    }

    public static Object readField(Object object, String string, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate field " + string + " on " + clazz);
        }
        return FieldUtils.readField(field, object);
    }

    public static Object readDeclaredField(Object object, String string) {
        return FieldUtils.readDeclaredField(object, string, false);
    }

    public static Object readDeclaredField(Object object, String string, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        return FieldUtils.readField(field, object);
    }

    public static void writeStaticField(Field field, Object object) {
        FieldUtils.writeStaticField(field, object, false);
    }

    public static void writeStaticField(Field field, Object object, boolean bl) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        FieldUtils.writeField(field, null, object, bl);
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object) {
        FieldUtils.writeStaticField(clazz, string, object, false);
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object, boolean bl) {
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate field " + string + " on " + clazz);
        }
        FieldUtils.writeStaticField(field, object);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string, Object object) {
        FieldUtils.writeDeclaredStaticField(clazz, string, object, false);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string, Object object, boolean bl) {
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        FieldUtils.writeField(field, null, object);
    }

    public static void writeField(Field field, Object object, Object object2) {
        FieldUtils.writeField(field, object, object2, false);
    }

    public static void writeField(Field field, Object object, Object object2, boolean bl) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (bl && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.a(field);
        }
        field.set(object, object2);
    }

    public static void writeField(Object object, String string, Object object2) {
        FieldUtils.writeField(object, string, object2, false);
    }

    public static void writeField(Object object, String string, Object object2, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        FieldUtils.writeField(field, object, object2);
    }

    public static void writeDeclaredField(Object object, String string, Object object2) {
        FieldUtils.writeDeclaredField(object, string, object2, false);
    }

    public static void writeDeclaredField(Object object, String string, Object object2, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        FieldUtils.writeField(field, object, object2);
    }
}

