/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MemberUtils;

public class ConstructorUtils {
    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return ConstructorUtils.invokeConstructor(clazz, objectArray, classArray);
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] object) {
        if (object == null) {
            object = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((object = ConstructorUtils.getMatchingAccessibleConstructor(clazz, object)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return ((Constructor)object).newInstance(objectArray);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object ... objectArray) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray, classArray);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] object) {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (object == null) {
            object = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((object = ConstructorUtils.getAccessibleConstructor(clazz, object)) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return ((Constructor)object).newInstance(objectArray);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        if (MemberUtils.a(constructor) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> constructorArray, Class<?> ... classArray) {
        try {
            Constructor<T> constructor = constructorArray.getConstructor(classArray);
            MemberUtils.a(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray2 = constructorArray.getConstructors();
            constructorArray = constructorArray2;
            constructorArray = constructorArray2;
            int n2 = constructorArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> constructor2 = constructorArray[i2];
                if (!ClassUtils.isAssignable(classArray, constructor2.getParameterTypes(), true) || (constructor2 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                MemberUtils.a(constructor2);
                if (constructor != null && MemberUtils.a(constructor2.getParameterTypes(), constructor.getParameterTypes(), classArray) >= 0) continue;
                constructor = constructor2;
            }
            return constructor;
        }
    }
}

