/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = 62986528375L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long l2) {
        this.value = l2;
    }

    public MutableLong(Number number) {
        this.value = number.longValue();
    }

    public MutableLong(String string) {
        this.value = Long.parseLong(string);
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(long l2) {
        this.value = l2;
    }

    @Override
    public void setValue(Number number) {
        this.value = number.longValue();
    }

    public void increment() {
        ++this.value;
    }

    public void decrement() {
        --this.value;
    }

    public void add(long l2) {
        this.value += l2;
    }

    public void add(Number number) {
        this.value += number.longValue();
    }

    public void subtract(long l2) {
        this.value -= l2;
    }

    public void subtract(Number number) {
        this.value -= number.longValue();
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public Long toLong() {
        return this.longValue();
    }

    public final boolean equals(Object object) {
        if (object instanceof MutableLong) {
            return this.value == ((MutableLong)object).longValue();
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int compareTo(MutableLong mutableLong) {
        long l2 = mutableLong.value;
        if (this.value < l2) {
            return -1;
        }
        if (this.value == l2) {
            return 0;
        }
        return 1;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }
}

