/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);

    public static int toInt(String string) {
        return NumberUtils.toInt(string, 0);
    }

    public static int toInt(String string, int n2) {
        if (string == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static long toLong(String string) {
        return NumberUtils.toLong(string, 0L);
    }

    public static long toLong(String string, long l2) {
        if (string == null) {
            return l2;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public static float toFloat(String string) {
        return NumberUtils.toFloat(string, 0.0f);
    }

    public static float toFloat(String string, float f2) {
        if (string == null) {
            return f2;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    public static double toDouble(String string) {
        return NumberUtils.toDouble(string, 0.0);
    }

    public static double toDouble(String string, double d2) {
        if (string == null) {
            return d2;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public static byte toByte(String string) {
        return NumberUtils.toByte(string, (byte)0);
    }

    public static byte toByte(String string, byte by) {
        if (string == null) {
            return by;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return by;
        }
    }

    public static short toShort(String string) {
        return NumberUtils.toShort(string, (short)0);
    }

    public static short toShort(String string, short s2) {
        if (string == null) {
            return s2;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return s2;
        }
    }

    public static Number createNumber(String string) {
        Object object;
        String string2;
        if (string == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (string.startsWith("--")) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("-0x") || string.startsWith("0X") || string.startsWith("-0X")) {
            return NumberUtils.createInteger(string);
        }
        char c2 = string.charAt(string.length() - 1);
        int n2 = string.indexOf(46);
        int n3 = string.indexOf(101) + string.indexOf(69) + 1;
        if (n2 >= 0) {
            if (n3 >= 0) {
                if (n3 < n2 || n3 > string.length()) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                string2 = string.substring(n2 + 1, n3);
            } else {
                string2 = string.substring(n2 + 1);
            }
            object = string.substring(0, n2);
        } else {
            if (n3 >= 0) {
                if (n3 > string.length()) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                object = string.substring(0, n3);
            } else {
                object = string;
            }
            string2 = null;
        }
        if (!Character.isDigit(c2) && c2 != '.') {
            String string3 = n3 >= 0 && n3 < string.length() - 1 ? string.substring(n3 + 1, string.length() - 1) : null;
            String string4 = string.substring(0, string.length() - 1);
            boolean bl = NumberUtils.isAllZeros((String)object) && NumberUtils.isAllZeros(string3);
            switch (c2) {
                case 'L': 
                case 'l': {
                    if (string2 == null && string3 == null && (string4.charAt(0) == '-' && NumberUtils.isDigits(string4.substring(1)) || NumberUtils.isDigits(string4))) {
                        try {
                            return NumberUtils.createLong(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(string4);
                        }
                    }
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f2 = NumberUtils.createFloat(string4);
                        if (!f2.isInfinite() && (f2.floatValue() != 0.0f || bl)) {
                            return f2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d2 = NumberUtils.createDouble(string4);
                        if (!d2.isInfinite() && ((double)d2.floatValue() != 0.0 || bl)) {
                            return d2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(string4);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            throw new NumberFormatException(string + " is not a valid number.");
        }
        String string5 = n3 >= 0 && n3 < string.length() - 1 ? string.substring(n3 + 1, string.length()) : null;
        if (string2 == null && string5 == null) {
            try {
                return NumberUtils.createInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(string);
                }
            }
        }
        boolean bl = NumberUtils.isAllZeros((String)object) && NumberUtils.isAllZeros(string5);
        try {
            object = NumberUtils.createFloat(string);
            if (!((Float)object).isInfinite() && (((Float)object).floatValue() != 0.0f || bl)) {
                return object;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = NumberUtils.createDouble(string);
            if (!((Double)object).isInfinite() && ((Double)object != 0.0 || bl)) {
                return object;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return NumberUtils.createBigDecimal(string);
    }

    private static boolean isAllZeros(String string) {
        if (string == null) {
            return true;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) == '0') continue;
            return false;
        }
        return string.length() > 0;
    }

    public static Float createFloat(String string) {
        if (string == null) {
            return null;
        }
        return Float.valueOf(string);
    }

    public static Double createDouble(String string) {
        if (string == null) {
            return null;
        }
        return Double.valueOf(string);
    }

    public static Integer createInteger(String string) {
        if (string == null) {
            return null;
        }
        return Integer.decode(string);
    }

    public static Long createLong(String string) {
        if (string == null) {
            return null;
        }
        return Long.decode(string);
    }

    public static BigInteger createBigInteger(String string) {
        if (string == null) {
            return null;
        }
        return new BigInteger(string);
    }

    public static BigDecimal createBigDecimal(String string) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(string);
    }

    public static long min(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (lArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static int min(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short min(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (sArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static byte min(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte by = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] >= by) continue;
            by = byArray[i2];
        }
        return by;
    }

    public static double min(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (Double.isNaN(dArray[i2])) {
                return Double.NaN;
            }
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static float min(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (Float.isNaN(fArray[i2])) {
                return Float.NaN;
            }
            if (!(fArray[i2] < f2)) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static long max(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (lArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] <= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static int max(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short max(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (sArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] <= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static byte max(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte by = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] <= by) continue;
            by = byArray[i2];
        }
        return by;
    }

    public static double max(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            if (Double.isNaN(dArray[i2])) {
                return Double.NaN;
            }
            if (!(dArray[i2] > d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static float max(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (Float.isNaN(fArray[i2])) {
                return Float.NaN;
            }
            if (!(fArray[i2] > f2)) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static long min(long l2, long l3, long l4) {
        if (l3 < l2) {
            l2 = l3;
        }
        if (l4 < l2) {
            l2 = l4;
        }
        return l2;
    }

    public static int min(int n2, int n3, int n4) {
        if (n3 < n2) {
            n2 = n3;
        }
        if (n4 < n2) {
            n2 = n4;
        }
        return n2;
    }

    public static short min(short s2, short s3, short s4) {
        if (s3 < s2) {
            s2 = s3;
        }
        if (s4 < s2) {
            s2 = s4;
        }
        return s2;
    }

    public static byte min(byte by, byte by2, byte by3) {
        if (by2 < by) {
            by = by2;
        }
        if (by3 < by) {
            by = by3;
        }
        return by;
    }

    public static double min(double d2, double d3, double d4) {
        return Math.min(Math.min(d2, d3), d4);
    }

    public static float min(float f2, float f3, float f4) {
        return Math.min(Math.min(f2, f3), f4);
    }

    public static long max(long l2, long l3, long l4) {
        if (l3 > l2) {
            l2 = l3;
        }
        if (l4 > l2) {
            l2 = l4;
        }
        return l2;
    }

    public static int max(int n2, int n3, int n4) {
        if (n3 > n2) {
            n2 = n3;
        }
        if (n4 > n2) {
            n2 = n4;
        }
        return n2;
    }

    public static short max(short s2, short s3, short s4) {
        if (s3 > s2) {
            s2 = s3;
        }
        if (s4 > s2) {
            s2 = s4;
        }
        return s2;
    }

    public static byte max(byte by, byte by2, byte by3) {
        if (by2 > by) {
            by = by2;
        }
        if (by3 > by) {
            by = by3;
        }
        return by;
    }

    public static double max(double d2, double d3, double d4) {
        return Math.max(Math.max(d2, d3), d4);
    }

    public static float max(float f2, float f3, float f4) {
        return Math.max(Math.max(f2, f3), f4);
    }

    public static boolean isDigits(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String object) {
        int n2;
        if (StringUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n3 = cArray.length;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = n2 = object[0] == 45 ? 1 : 0;
        if (n3 > n2 + 1 && object[n2] == 48 && object[n2 + 1] == 120) {
            if ((n2 += 2) == n3) {
                return false;
            }
            while (n2 < ((Object)object).length) {
                if (!(object[n2] >= 48 && object[n2] <= 57 || object[n2] >= 97 && object[n2] <= 102 || object[n2] >= 65 && object[n2] <= 70)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        --n3;
        while (n2 < n3 || n2 < n3 + 1 && bl3 && !bl4) {
            if (object[n2] >= 48 && object[n2] <= 57) {
                bl4 = true;
                bl3 = false;
            } else if (object[n2] == 46) {
                if (bl2 || bl) {
                    return false;
                }
                bl2 = true;
            } else if (object[n2] == 101 || object[n2] == 69) {
                if (bl) {
                    return false;
                }
                if (!bl4) {
                    return false;
                }
                bl = true;
                bl3 = true;
            } else if (object[n2] == 43 || object[n2] == 45) {
                if (!bl3) {
                    return false;
                }
                bl3 = false;
                bl4 = false;
            } else {
                return false;
            }
            ++n2;
        }
        if (n2 < ((Object)object).length) {
            if (object[n2] >= 48 && object[n2] <= 57) {
                return true;
            }
            if (object[n2] == 101 || object[n2] == 69) {
                return false;
            }
            if (object[n2] == 46) {
                if (bl2 || bl) {
                    return false;
                }
                return bl4;
            }
            if (!(bl3 || object[n2] != 100 && object[n2] != 68 && object[n2] != 102 && object[n2] != 70)) {
                return bl4;
            }
            if (object[n2] == 108 || object[n2] == 76) {
                return bl4 && !bl && !bl2;
            }
            return false;
        }
        return !bl3 && bl4;
    }
}

