/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils$ConstantFuture;

public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentRuntimeException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException exception) {
        if ((exception = ConcurrentUtils.extractCause(exception)) != null) {
            throw exception;
        }
    }

    public static void handleCauseUnchecked(ExecutionException exception) {
        if ((exception = ConcurrentUtils.extractCauseUnchecked(exception)) != null) {
            throw exception;
        }
    }

    static Throwable a(Throwable throwable) {
        if (throwable != null && !(throwable instanceof RuntimeException) && !(throwable instanceof Error)) {
            return throwable;
        }
        throw new IllegalArgumentException("Not a checked exception: " + throwable);
    }

    private static void throwCause(ExecutionException executionException) {
        if (executionException.getCause() instanceof RuntimeException) {
            throw (RuntimeException)executionException.getCause();
        }
        if (executionException.getCause() instanceof Error) {
            throw (Error)executionException.getCause();
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> concurrentInitializer) {
        if (concurrentInitializer != null) {
            return concurrentInitializer.get();
        }
        return null;
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> concurrentInitializer) {
        try {
            return ConcurrentUtils.initialize(concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, V v2) {
        if (concurrentMap == null) {
            return null;
        }
        if ((concurrentMap = concurrentMap.putIfAbsent(k2, v2)) != null) {
            return (V)concurrentMap;
        }
        return v2;
    }

    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) {
        if (concurrentMap == null || concurrentInitializer == null) {
            return null;
        }
        Object v2 = concurrentMap.get(k2);
        if (v2 == null) {
            return ConcurrentUtils.putIfAbsent(concurrentMap, k2, concurrentInitializer.get());
        }
        return v2;
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) {
        try {
            return ConcurrentUtils.createIfAbsent(concurrentMap, k2, concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <T> Future<T> constantFuture(T t2) {
        return new ConcurrentUtils$ConstantFuture<T>(t2);
    }
}

