/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ReflectionToStringBuilder
extends ToStringBuilder {
    private boolean appendStatics = false;
    private boolean appendTransients = false;
    protected String[] excludeFieldNames;
    private Class<?> upToClass = null;

    public static String toString(Object object) {
        return ReflectionToStringBuilder.toString(object, null, false, false, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, false, false, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle, boolean bl) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, bl, false, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle, boolean bl, boolean bl2) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, bl, bl2, null);
    }

    public static <T> String toString(T t2, ToStringStyle toStringStyle, boolean bl, boolean bl2, Class<? super T> clazz) {
        return new ReflectionToStringBuilder(t2, toStringStyle, null, clazz, bl, bl2).toString();
    }

    public static String toStringExclude(Object object, Collection<String> collection) {
        return ReflectionToStringBuilder.toStringExclude(object, ReflectionToStringBuilder.a(collection));
    }

    static String[] a(Collection<String> collection) {
        if (collection == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ReflectionToStringBuilder.toNoNullStringArray(collection.toArray());
    }

    private static String[] toNoNullStringArray(Object[] objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        for (Object object : objectArray) {
            if (object == null) continue;
            arrayList.add(object.toString());
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String toStringExclude(Object object, String ... stringArray) {
        return new ReflectionToStringBuilder(object).setExcludeFieldNames(stringArray).toString();
    }

    public ReflectionToStringBuilder(Object object) {
        super(object);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle toStringStyle) {
        super(object, toStringStyle);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle toStringStyle, StringBuffer stringBuffer) {
        super(object, toStringStyle, stringBuffer);
    }

    public <T> ReflectionToStringBuilder(T t2, ToStringStyle toStringStyle, StringBuffer stringBuffer, Class<? super T> clazz, boolean bl, boolean bl2) {
        super(t2, toStringStyle, stringBuffer);
        this.setUpToClass(clazz);
        this.setAppendTransients(bl);
        this.setAppendStatics(bl2);
    }

    protected boolean accept(Field field) {
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers()) && !this.isAppendTransients()) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers()) && !this.isAppendStatics()) {
            return false;
        }
        return this.excludeFieldNames == null || Arrays.binarySearch(this.excludeFieldNames, field.getName()) < 0;
    }

    protected void appendFieldsIn(Class<?> accessibleObjectArray) {
        if (accessibleObjectArray.isArray()) {
            this.reflectionAppendArray(this.getObject());
            return;
        }
        accessibleObjectArray = accessibleObjectArray.getDeclaredFields();
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject illegalAccessException : accessibleObjectArray) {
            String string = ((Field)illegalAccessException).getName();
            if (!this.accept((Field)illegalAccessException)) continue;
            try {
                Object object = this.getValue((Field)illegalAccessException);
                this.append(string, object);
            }
            catch (IllegalAccessException illegalAccessException2) {
                throw new InternalError("Unexpected IllegalAccessException: " + illegalAccessException2.getMessage());
            }
        }
    }

    public String[] getExcludeFieldNames() {
        return (String[])this.excludeFieldNames.clone();
    }

    public Class<?> getUpToClass() {
        return this.upToClass;
    }

    protected Object getValue(Field field) {
        return field.get(this.getObject());
    }

    public boolean isAppendStatics() {
        return this.appendStatics;
    }

    public boolean isAppendTransients() {
        return this.appendTransients;
    }

    public ReflectionToStringBuilder reflectionAppendArray(Object object) {
        this.getStyle().reflectionAppendArrayDetail(this.getStringBuffer(), null, object);
        return this;
    }

    public void setAppendStatics(boolean bl) {
        this.appendStatics = bl;
    }

    public void setAppendTransients(boolean bl) {
        this.appendTransients = bl;
    }

    public ReflectionToStringBuilder setExcludeFieldNames(String ... stringArray) {
        if (stringArray == null) {
            this.excludeFieldNames = null;
        } else {
            this.excludeFieldNames = ReflectionToStringBuilder.toNoNullStringArray(stringArray);
            Arrays.sort(this.excludeFieldNames);
        }
        return this;
    }

    public void setUpToClass(Class<?> clazz) {
        Object object;
        if (clazz != null && (object = this.getObject()) != null && !clazz.isInstance(object)) {
            throw new IllegalArgumentException("Specified class is not a superclass of the object");
        }
        this.upToClass = clazz;
    }

    @Override
    public final String toString() {
        Class<?> clazz;
        if (this.getObject() == null) {
            return this.getStyle().getNullText();
        }
        this.appendFieldsIn(clazz);
        for (clazz = this.getObject().getClass(); clazz.getSuperclass() != null && clazz != this.getUpToClass(); clazz = clazz.getSuperclass()) {
            this.appendFieldsIn(clazz);
        }
        return super.toString();
    }
}

