/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.Range$ComparableComparator;

public final class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private final T minimum;
    private final T maximum;
    private transient int hashCode;
    private transient String toString;

    public static <T extends Comparable<T>> Range<T> is(T t2) {
        return Range.between(t2, t2, null);
    }

    public static <T> Range<T> is(T t2, Comparator<T> comparator) {
        return Range.between(t2, t2, comparator);
    }

    public static <T extends Comparable<T>> Range<T> between(T t2, T t3) {
        return Range.between(t2, t3, null);
    }

    public static <T> Range<T> between(T t2, T t3, Comparator<T> comparator) {
        return new Range<T>(t2, t3, comparator);
    }

    private Range(T t2, T t3, Comparator<T> range$ComparableComparator) {
        if (t2 == null || t3 == null) {
            throw new IllegalArgumentException("Elements in a range must not be null: element1=" + t2 + ", element2=" + t3);
        }
        if (range$ComparableComparator == null) {
            range$ComparableComparator = Range$ComparableComparator.INSTANCE;
        }
        if (range$ComparableComparator.compare(t2, t3) <= 0) {
            this.minimum = t2;
            this.maximum = t3;
        } else {
            this.minimum = t3;
            this.maximum = t2;
        }
        this.comparator = range$ComparableComparator;
    }

    public final T getMinimum() {
        return this.minimum;
    }

    public final T getMaximum() {
        return this.maximum;
    }

    public final Comparator<T> getComparator() {
        return this.comparator;
    }

    public final boolean isNaturalOrdering() {
        return this.comparator == Range$ComparableComparator.INSTANCE;
    }

    public final boolean contains(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.minimum) >= 0 && this.comparator.compare(t2, this.maximum) <= 0;
    }

    public final boolean isAfter(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.minimum) < 0;
    }

    public final boolean isStartedBy(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.minimum) == 0;
    }

    public final boolean isEndedBy(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.maximum) == 0;
    }

    public final boolean isBefore(T t2) {
        if (t2 == null) {
            return false;
        }
        return this.comparator.compare(t2, this.maximum) > 0;
    }

    public final int elementCompareTo(T t2) {
        if (t2 == null) {
            throw new NullPointerException("Element is null");
        }
        if (this.isAfter(t2)) {
            return -1;
        }
        if (this.isBefore(t2)) {
            return 1;
        }
        return 0;
    }

    public final boolean containsRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.contains(range.minimum) && this.contains(range.maximum);
    }

    public final boolean isAfterRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isAfter(range.maximum);
    }

    public final boolean isOverlappedBy(Range<T> range) {
        if (range == null) {
            return false;
        }
        return range.contains(this.minimum) || range.contains(this.maximum) || this.contains(range.minimum);
    }

    public final boolean isBeforeRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.isBefore(range.minimum);
    }

    public final Range<T> intersectionWith(Range<T> range) {
        if (!this.isOverlappedBy(range)) {
            throw new IllegalArgumentException(String.format("Cannot calculate intersection with non-overlapping range %s", range));
        }
        if (this.equals(range)) {
            return this;
        }
        T t2 = this.getComparator().compare(this.minimum, range.minimum) < 0 ? range.minimum : this.minimum;
        range = this.getComparator().compare(this.maximum, range.maximum) < 0 ? this.maximum : range.maximum;
        return Range.between(t2, range, this.getComparator());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Range)object;
        return this.minimum.equals(((Range)object).minimum) && this.maximum.equals(((Range)object).maximum);
    }

    public final int hashCode() {
        int n2 = this.hashCode;
        if (this.hashCode == 0) {
            n2 = 629 + this.getClass().hashCode();
            n2 = n2 * 37 + this.minimum.hashCode();
            this.hashCode = n2 = n2 * 37 + this.maximum.hashCode();
        }
        return n2;
    }

    public final String toString() {
        CharSequence charSequence = this.toString;
        if (charSequence == null) {
            charSequence = new StringBuilder(32);
            ((StringBuilder)charSequence).append('[');
            ((StringBuilder)charSequence).append(this.minimum);
            ((StringBuilder)charSequence).append("..");
            ((StringBuilder)charSequence).append(this.maximum);
            ((StringBuilder)charSequence).append(']');
            charSequence = ((StringBuilder)charSequence).toString();
            this.toString = charSequence;
        }
        return charSequence;
    }

    public final String toString(String string) {
        return String.format(string, this.minimum, this.maximum, this.comparator);
    }
}

