/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumArray) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> clazz) {
        return new ArrayList<E>(Arrays.asList(clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> clazz, String string) {
        if (string == null) {
            return false;
        }
        try {
            Enum.valueOf(clazz, string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string) {
        if (string == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> object, Iterable<E> object2) {
        EnumUtils.checkBitVectorable(object);
        Validate.notNull(object2);
        long l2 = 0L;
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (Enum)object.next();
            l2 |= (long)(1 << ((Enum)object2).ordinal());
        }
        return l2;
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> clazz, E ... EArray) {
        Validate.noNullElements(EArray);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(EArray));
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> serializable, long l2) {
        Enum[] enumArray = (Enum[])EnumUtils.checkBitVectorable(serializable).getEnumConstants();
        serializable = EnumSet.noneOf(serializable);
        for (Enum enum_ : enumArray) {
            if ((l2 & (long)(1 << enum_.ordinal())) == 0L) continue;
            ((AbstractCollection)((Object)serializable)).add((Enum)enum_);
        }
        return serializable;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> clazz) {
        Validate.notNull(clazz, "EnumClass must be defined.", new Object[0]);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        Validate.isTrue(enumArray != null, "%s does not seem to be an Enum type", clazz);
        Validate.isTrue(enumArray.length <= 64, "Cannot store %s %s values in %s bits", enumArray.length, clazz.getSimpleName(), 64);
        return clazz;
    }
}

