/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.ReversedLinesFileReader$FilePart;

public class ReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private ReversedLinesFileReader$FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    public ReversedLinesFileReader(File file) {
        this(file, 4096, Charset.defaultCharset().toString());
    }

    public ReversedLinesFileReader(File file, int n2, Charset charset) {
        this.blockSize = n2;
        this.encoding = charset;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.totalByteLength = this.randomAccessFile.length();
        int n3 = (int)(this.totalByteLength % (long)n2);
        if (n3 > 0) {
            this.totalBlockCount = this.totalByteLength / (long)n2 + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)n2;
            if (this.totalByteLength > 0L) {
                n3 = n2;
            }
        }
        this.currentFilePart = new ReversedLinesFileReader$FilePart(this, this.totalBlockCount, n3, null);
        Charset charset2 = Charsets.toCharset(charset);
        CharsetEncoder charsetEncoder = charset2.newEncoder();
        float f2 = charsetEncoder.maxBytesPerChar();
        if (f2 == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset2 == Charset.forName("UTF-8")) {
            this.byteDecrement = 1;
        } else if (charset2 == Charset.forName("Shift_JIS")) {
            this.byteDecrement = 1;
        } else if (charset2 == Charset.forName("UTF-16BE") || charset2 == Charset.forName("UTF-16LE")) {
            this.byteDecrement = 2;
        } else {
            if (charset2 == Charset.forName("UTF-16")) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(charset), "\n".getBytes(charset), "\r".getBytes(charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
    }

    public ReversedLinesFileReader(File file, int n2, String string) {
        this(file, n2, Charsets.toCharset(string));
    }

    public String readLine() {
        String string = ReversedLinesFileReader$FilePart.a(this.currentFilePart);
        while (string == null) {
            this.currentFilePart = ReversedLinesFileReader$FilePart.b(this.currentFilePart);
            if (this.currentFilePart == null) break;
            string = ReversedLinesFileReader$FilePart.a(this.currentFilePart);
        }
        if ("".equals(string) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            string = this.readLine();
        }
        return string;
    }

    @Override
    public void close() {
        this.randomAccessFile.close();
    }

    static /* synthetic */ int a(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.blockSize;
    }

    static /* synthetic */ RandomAccessFile b(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.randomAccessFile;
    }

    static /* synthetic */ Charset c(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.encoding;
    }

    static /* synthetic */ int d(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.avoidNewlineSplitBufferSize;
    }

    static /* synthetic */ int e(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.byteDecrement;
    }

    static /* synthetic */ byte[][] f(ReversedLinesFileReader reversedLinesFileReader) {
        return reversedLinesFileReader.newLineSequences;
    }
}

