/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharSequenceInputStream
extends InputStream {
    private final CharsetEncoder encoder;
    private final CharBuffer cbuf;
    private final ByteBuffer bbuf;
    private int mark;

    public CharSequenceInputStream(CharSequence charSequence, Charset charset, int n2) {
        this.encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.bbuf = ByteBuffer.allocate(n2);
        this.bbuf.flip();
        this.cbuf = CharBuffer.wrap(charSequence);
        this.mark = -1;
    }

    public CharSequenceInputStream(CharSequence charSequence, String string, int n2) {
        this(charSequence, Charset.forName(string), n2);
    }

    public CharSequenceInputStream(CharSequence charSequence, Charset charset) {
        this(charSequence, charset, 2048);
    }

    public CharSequenceInputStream(CharSequence charSequence, String string) {
        this(charSequence, string, 2048);
    }

    private void fillBuffer() {
        this.bbuf.compact();
        CoderResult coderResult = this.encoder.encode(this.cbuf, this.bbuf, true);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.bbuf.flip();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + byArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        if (n3 == 0) {
            return 0;
        }
        if (!this.bbuf.hasRemaining() && !this.cbuf.hasRemaining()) {
            return -1;
        }
        int n4 = 0;
        while (n3 > 0) {
            if (this.bbuf.hasRemaining()) {
                int n5 = Math.min(this.bbuf.remaining(), n3);
                this.bbuf.get(byArray, n2, n5);
                n2 += n5;
                n3 -= n5;
                n4 += n5;
                continue;
            }
            this.fillBuffer();
            if (this.bbuf.hasRemaining() || this.cbuf.hasRemaining()) continue;
        }
        if (n4 == 0 && !this.cbuf.hasRemaining()) {
            return -1;
        }
        return n4;
    }

    @Override
    public int read() {
        do {
            if (this.bbuf.hasRemaining()) {
                return this.bbuf.get() & 0xFF;
            }
            this.fillBuffer();
        } while (this.bbuf.hasRemaining() || this.cbuf.hasRemaining());
        return -1;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l2) {
        int n2 = 0;
        while (l2 > 0L && this.cbuf.hasRemaining()) {
            this.cbuf.get();
            --l2;
            ++n2;
        }
        return n2;
    }

    @Override
    public int available() {
        return this.cbuf.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void mark(int n2) {
        this.mark = this.cbuf.position();
    }

    @Override
    public synchronized void reset() {
        if (this.mark != -1) {
            this.cbuf.position(this.mark);
            this.mark = -1;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

