/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream$1;
import org.apache.commons.io.input.ProxyInputStream;

public class BOMInputStream
extends ProxyInputStream {
    private final boolean include;
    private final List<ByteOrderMark> boms;
    private ByteOrderMark byteOrderMark;
    private int[] firstBytes;
    private int fbLength;
    private int fbIndex;
    private int markFbIndex;
    private boolean markedAtStart;
    private static final Comparator<ByteOrderMark> ByteOrderMarkLengthComparator = new BOMInputStream$1();

    public BOMInputStream(InputStream inputStream) {
        this(inputStream, false, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, boolean bl) {
        this(inputStream, bl, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(InputStream inputStream, ByteOrderMark ... byteOrderMarkArray) {
        this(inputStream, false, byteOrderMarkArray);
    }

    public BOMInputStream(InputStream inputStream, boolean bl, ByteOrderMark ... byteOrderMarkArray) {
        super(inputStream);
        if (byteOrderMarkArray == null || byteOrderMarkArray.length == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.include = bl;
        Arrays.sort(byteOrderMarkArray, ByteOrderMarkLengthComparator);
        this.boms = Arrays.asList(byteOrderMarkArray);
    }

    public boolean hasBOM() {
        return this.getBOM() != null;
    }

    public boolean hasBOM(ByteOrderMark byteOrderMark) {
        if (!this.boms.contains(byteOrderMark)) {
            throw new IllegalArgumentException("Stream not configure to detect " + byteOrderMark);
        }
        return this.byteOrderMark != null && this.getBOM().equals(byteOrderMark);
    }

    public ByteOrderMark getBOM() {
        if (this.firstBytes == null) {
            this.fbLength = 0;
            int n2 = this.boms.get(0).length();
            this.firstBytes = new int[n2];
            for (n2 = 0; n2 < this.firstBytes.length; ++n2) {
                this.firstBytes[n2] = this.in.read();
                ++this.fbLength;
                if (this.firstBytes[n2] < 0) break;
            }
            this.byteOrderMark = this.find();
            if (this.byteOrderMark != null && !this.include) {
                if (this.byteOrderMark.length() < this.firstBytes.length) {
                    this.fbIndex = this.byteOrderMark.length();
                } else {
                    this.fbLength = 0;
                }
            }
        }
        return this.byteOrderMark;
    }

    public String getBOMCharsetName() {
        this.getBOM();
        if (this.byteOrderMark == null) {
            return null;
        }
        return this.byteOrderMark.getCharsetName();
    }

    private int readFirstBytes() {
        this.getBOM();
        if (this.fbIndex < this.fbLength) {
            return this.firstBytes[this.fbIndex++];
        }
        return -1;
    }

    private ByteOrderMark find() {
        for (ByteOrderMark byteOrderMark : this.boms) {
            if (!this.matches(byteOrderMark)) continue;
            return byteOrderMark;
        }
        return null;
    }

    private boolean matches(ByteOrderMark byteOrderMark) {
        for (int i2 = 0; i2 < byteOrderMark.length(); ++i2) {
            if (byteOrderMark.get(i2) == this.firstBytes[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int read() {
        int n2 = this.readFirstBytes();
        if (n2 >= 0) {
            return n2;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0 && n5 >= 0) {
            n5 = this.readFirstBytes();
            if (n5 < 0) continue;
            byArray[n2++] = (byte)n5;
            --n3;
            ++n4;
        }
        int n6 = this.in.read(byArray, n2, n3);
        if (n6 < 0) {
            if (n4 > 0) {
                return n4;
            }
            return -1;
        }
        return n4 + n6;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void mark(int n2) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(n2);
    }

    @Override
    public synchronized void reset() {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Override
    public long skip(long l2) {
        while (l2 > 0L && this.readFirstBytes() >= 0) {
            --l2;
        }
        return this.in.skip(l2);
    }
}

