/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] wildcards;

    public WildcardFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
    }

    public WildcardFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.wildcards, 0, stringArray.length);
    }

    public WildcardFilter(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
    }

    @Override
    public boolean accept(File stringArray, String string) {
        if (stringArray != null && new File((File)stringArray, string).isDirectory()) {
            return false;
        }
        stringArray = this.wildcards;
        int n2 = this.wildcards.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!FilenameUtils.wildcardMatch(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String[] stringArray = this.wildcards;
        int n2 = this.wildcards.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!FilenameUtils.wildcardMatch(file.getName(), string)) continue;
            return true;
        }
        return false;
    }
}

