/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] wildcards;
    private final IOCase caseSensitivity;

    public WildcardFileFilter(String string) {
        this(string, null);
    }

    public WildcardFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public WildcardFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.wildcards, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(List<String> list) {
        this(list, null);
    }

    public WildcardFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File stringArray, String string) {
        stringArray = this.wildcards;
        int n2 = this.wildcards.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!FilenameUtils.wildcardMatch(string, string2, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File object) {
        object = ((File)object).getName();
        String[] stringArray = this.wildcards;
        int n2 = this.wildcards.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!FilenameUtils.wildcardMatch((String)object, string, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.wildcards != null) {
            for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.wildcards[i2]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

