/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SuffixFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] suffixes;
    private final IOCase caseSensitivity;

    public SuffixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public SuffixFileFilter(String[] stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.suffixes, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public SuffixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File object) {
        object = ((File)object).getName();
        String[] stringArray = this.suffixes;
        int n2 = this.suffixes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!this.caseSensitivity.checkEndsWith((String)object, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File stringArray, String string) {
        stringArray = this.suffixes;
        int n2 = this.suffixes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!this.caseSensitivity.checkEndsWith(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.suffixes != null) {
            for (int i2 = 0; i2 < this.suffixes.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.suffixes[i2]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

