/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] prefixes;
    private final IOCase caseSensitivity;

    public PrefixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.prefixes = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public PrefixFileFilter(String[] stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.prefixes, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public PrefixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File object) {
        object = ((File)object).getName();
        String[] stringArray = this.prefixes;
        int n2 = this.prefixes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!this.caseSensitivity.checkStartsWith((String)object, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File stringArray, String string) {
        stringArray = this.prefixes;
        int n2 = this.prefixes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!this.caseSensitivity.checkStartsWith(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.prefixes != null) {
            for (int i2 = 0; i2 < this.prefixes.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.prefixes[i2]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

