/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] names;
    private final IOCase caseSensitivity;

    public NameFileFilter(String string) {
        this(string, null);
    }

    public NameFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public NameFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.names, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(List<String> list) {
        this(list, null);
    }

    public NameFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File object) {
        object = ((File)object).getName();
        String[] stringArray = this.names;
        int n2 = this.names.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (!this.caseSensitivity.checkEquals((String)object, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File stringArray, String string) {
        stringArray = this.names;
        int n2 = this.names.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!this.caseSensitivity.checkEquals(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.names != null) {
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.names[i2]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

