/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class MagicNumberFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -547733176983104172L;
    private final byte[] magicNumbers;
    private final long byteOffset;

    public MagicNumberFileFilter(byte[] byArray) {
        this(byArray, 0L);
    }

    public MagicNumberFileFilter(String string) {
        this(string, 0L);
    }

    public MagicNumberFileFilter(String string, long l2) {
        if (string == null) {
            throw new IllegalArgumentException("The magic number cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.magicNumbers = string.getBytes();
        this.byteOffset = l2;
    }

    public MagicNumberFileFilter(byte[] byArray, long l2) {
        if (byArray == null) {
            throw new IllegalArgumentException("The magic number cannot be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.magicNumbers = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.magicNumbers, 0, byArray.length);
        this.byteOffset = l2;
    }

    @Override
    public boolean accept(File file) {
        block6: {
            if (file != null && file.isFile() && file.canRead()) {
                boolean throwable;
                byte[] byArray;
                RandomAccessFile randomAccessFile;
                block5: {
                    randomAccessFile = null;
                    byArray = new byte[this.magicNumbers.length];
                    randomAccessFile = new RandomAccessFile(file, "r");
                    randomAccessFile.seek(this.byteOffset);
                    int bl = randomAccessFile.read(byArray);
                    if (bl == this.magicNumbers.length) break block5;
                    IOUtils.closeQuietly(randomAccessFile);
                    return false;
                }
                try {
                    throwable = Arrays.equals(this.magicNumbers, byArray);
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(randomAccessFile);
                    break block6;
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(randomAccessFile);
                    throw throwable2;
                }
                IOUtils.closeQuietly(randomAccessFile);
                return throwable;
            }
        }
        return false;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("(");
        stringBuilder.append(new String(this.magicNumbers));
        stringBuilder.append(",");
        stringBuilder.append(this.byteOffset);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

