/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;

public class CompositeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final Comparator<?>[] NO_COMPARATORS = new Comparator[0];
    private final Comparator<File>[] delegates;

    public CompositeFileComparator(Comparator<File> ... comparatorArray) {
        if (comparatorArray == null) {
            this.delegates = NO_COMPARATORS;
            return;
        }
        this.delegates = new Comparator[comparatorArray.length];
        System.arraycopy(comparatorArray, 0, this.delegates, 0, comparatorArray.length);
    }

    public CompositeFileComparator(Iterable<Comparator<File>> object) {
        if (object == null) {
            this.delegates = NO_COMPARATORS;
            return;
        }
        ArrayList<Comparator> arrayList = new ArrayList<Comparator>();
        object = object.iterator();
        while (object.hasNext()) {
            Comparator comparator = (Comparator)object.next();
            arrayList.add(comparator);
        }
        this.delegates = arrayList.toArray(new Comparator[arrayList.size()]);
    }

    @Override
    public int compare(File file, File file2) {
        Comparator<File> comparator;
        int n2 = 0;
        Comparator<File>[] comparatorArray = this.delegates;
        int n3 = this.delegates.length;
        for (int i2 = 0; i2 < n3 && (n2 = (comparator = comparatorArray[i2]).compare(file, file2)) == 0; ++i2) {
        }
        return n2;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append('{');
        for (int i2 = 0; i2 < this.delegates.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.delegates[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

