/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;

public class IOUtils {
    private static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static char[] SKIP_CHAR_BUFFER;
    private static byte[] SKIP_BYTE_BUFFER;

    public static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    public static void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeQuietly(Selector selector) {
        if (selector != null) {
            try {
                selector.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l2);
        }
        return IOUtils.toByteArray(inputStream, (int)l2);
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
        }
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Unexpected readed size. current: " + n3 + ", excepted: " + n2);
        }
        return byArray;
    }

    public static byte[] toByteArray(Reader reader) {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader reader, Charset charset) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream, charset);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes();
    }

    public static byte[] toByteArray(URI uRI) {
        return IOUtils.toByteArray(uRI.toURL());
    }

    public static byte[] toByteArray(URL object) {
        object = ((URL)object).openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray((URLConnection)object);
            return byArray;
        }
        finally {
            IOUtils.close((URLConnection)object);
        }
    }

    public static byte[] toByteArray(URLConnection object) {
        object = ((URLConnection)object).getInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)object);
            return byArray;
        }
        finally {
            ((InputStream)object).close();
        }
    }

    public static char[] toCharArray(InputStream inputStream) {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static String toString(InputStream inputStream) {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream inputStream, Charset charset) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        IOUtils.copy(inputStream, (Writer)stringBuilderWriter, charset);
        return stringBuilderWriter.toString();
    }

    public static String toString(InputStream inputStream, String string) {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static String toString(Reader reader) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        IOUtils.copy(reader, (Writer)stringBuilderWriter);
        return stringBuilderWriter.toString();
    }

    public static String toString(URI uRI) {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static String toString(URI uRI, Charset charset) {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static String toString(URI uRI, String string) {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    public static String toString(URL uRL) {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    public static String toString(URL object, Charset object2) {
        object = ((URL)object).openStream();
        try {
            object2 = IOUtils.toString((InputStream)object, (Charset)object2);
            return object2;
        }
        finally {
            ((InputStream)object).close();
        }
    }

    public static String toString(URL uRL, String string) {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    public static String toString(byte[] byArray) {
        return new String(byArray);
    }

    public static String toString(byte[] byArray, String string) {
        return new String(byArray, Charsets.toCharset(string));
    }

    public static List<String> readLines(InputStream inputStream) {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream closeable, Charset charset) {
        closeable = new InputStreamReader((InputStream)closeable, Charsets.toCharset(charset));
        return IOUtils.readLines((Reader)closeable);
    }

    public static List<String> readLines(InputStream inputStream, String string) {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static List<String> readLines(Reader reader) {
        reader = IOUtils.toBufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ((BufferedReader)reader).readLine();
        while (string != null) {
            arrayList.add(string);
            string = ((BufferedReader)reader).readLine();
        }
        return arrayList;
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIterator(InputStream inputStream, Charset charset) {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(((Object)charSequence).toString(), charset);
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String object, String string) {
        object = ((String)object).getBytes(Charsets.toCharset(string));
        return new ByteArrayInputStream((byte[])object);
    }

    public static void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static void write(byte[] byArray, Writer writer, Charset charset) {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    public static void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream) {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static void write(char[] cArray, OutputStream outputStream, Charset charset) {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static void write(CharSequence charSequence, Writer writer) {
        if (charSequence != null) {
            IOUtils.write(((Object)charSequence).toString(), writer);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream) {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, Charset charset) {
        if (charSequence != null) {
            IOUtils.write(((Object)charSequence).toString(), outputStream, charset);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    public static void write(String string, OutputStream outputStream) {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static void write(String string, OutputStream outputStream, Charset charset) {
        if (string != null) {
            outputStream.write(string.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    public static void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream) {
        IOUtils.write(stringBuffer, outputStream, null);
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes(Charsets.toCharset(string)));
        }
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream) {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> object, String string, OutputStream outputStream, Charset charset) {
        if (object == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        charset = Charsets.toCharset(charset);
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) {
                outputStream.write(e2.toString().getBytes(charset));
            }
            outputStream.write(string.getBytes(charset));
        }
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, String string2) {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static void writeLines(Collection<?> object, String string, Writer writer) {
        if (object == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) {
                writer.write(e2.toString());
            }
            writer.write(string);
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copyLarge(inputStream, outputStream, new byte[4096]);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, new byte[4096]);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    public static void copy(InputStream inputStream, Writer writer) {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static void copy(InputStream closeable, Writer writer, Charset charset) {
        closeable = new InputStreamReader((InputStream)closeable, Charsets.toCharset(charset));
        IOUtils.copy((Reader)closeable, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static int copy(Reader reader, Writer writer) {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IOUtils.copyLarge(reader, writer, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) {
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3) {
        return IOUtils.copyLarge(reader, writer, l2, l3, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3, char[] cArray) {
        int n2;
        if (l2 > 0L) {
            IOUtils.skipFully(reader, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n3 = cArray.length;
        if (l3 > 0L && l3 < (long)cArray.length) {
            n3 = (int)l3;
        }
        long l4 = 0L;
        while (n3 > 0 && -1 != (n2 = reader.read(cArray, 0, n3))) {
            writer.write(cArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n3 = (int)Math.min(l3 - l4, (long)cArray.length);
        }
        return l4;
    }

    public static void copy(Reader reader, OutputStream outputStream) {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static void copy(Reader reader, OutputStream closeable, Charset charset) {
        closeable = new OutputStreamWriter((OutputStream)closeable, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)closeable);
        ((OutputStreamWriter)closeable).flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n3 = inputStream.read();
        while (-1 != n3) {
            n2 = inputStream2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = inputStream.read();
        }
        n2 = inputStream2.read();
        return n2 == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        int n2;
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        int n3 = reader.read();
        while (-1 != n3) {
            n2 = reader2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = reader.read();
        }
        n2 = reader2.read();
        return n2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) {
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        String string = ((BufferedReader)reader).readLine();
        String string2 = ((BufferedReader)reader2).readLine();
        while (string != null && string2 != null && string.equals(string2)) {
            string = ((BufferedReader)reader).readLine();
            string2 = ((BufferedReader)reader2).readLine();
        }
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static long skip(InputStream inputStream, long l2) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (SKIP_BYTE_BUFFER == null) {
            SKIP_BYTE_BUFFER = new byte[2048];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(l3, 2048L))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static long skip(Reader reader, long l2) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[2048];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)reader.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(l3, 2048L))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(inputStream, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(Reader reader, long l2) {
        long l3 = IOUtils.skip(reader, l2);
        if (l3 != l2) {
            throw new EOFException("Chars to skip: " + l2 + " actual: " + l3);
        }
    }

    public static int read(Reader reader, char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n4 = n3; n4 > 0; n4 -= n5) {
            n5 = n3 - n4;
            if (-1 == (n5 = reader.read(cArray, n2 + n5, n4))) break;
        }
        return n3 - n4;
    }

    public static int read(Reader reader, char[] cArray) {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n4 = n3; n4 > 0; n4 -= n5) {
            n5 = n3 - n4;
            if (-1 == (n5 = inputStream.read(byArray, n2 + n5, n4))) break;
        }
        return n3 - n4;
    }

    public static int read(InputStream inputStream, byte[] byArray) {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(Reader reader, char[] cArray, int n2, int n3) {
        int n4 = IOUtils.read(reader, cArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static void readFully(Reader reader, char[] cArray) {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = IOUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray) {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    static {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(4);
        PrintWriter printWriter = new PrintWriter(stringBuilderWriter);
        printWriter.println();
        LINE_SEPARATOR = stringBuilderWriter.toString();
        printWriter.close();
    }
}

