/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;

public final class IOCase
implements Serializable {
    public static final IOCase SENSITIVE = new IOCase("Sensitive", true);
    public static final IOCase INSENSITIVE = new IOCase("Insensitive", false);
    public static final IOCase SYSTEM = new IOCase("System", !FilenameUtils.a());
    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    public static IOCase forName(String string) {
        if (IOCase.SENSITIVE.name.equals(string)) {
            return SENSITIVE;
        }
        if (IOCase.INSENSITIVE.name.equals(string)) {
            return INSENSITIVE;
        }
        if (IOCase.SYSTEM.name.equals(string)) {
            return SYSTEM;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + string);
    }

    private IOCase(String string, boolean bl) {
        this.name = string;
        this.sensitive = bl;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isCaseSensitive() {
        return this.sensitive;
    }

    public final int checkCompareTo(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.sensitive) {
            return string.compareTo(string2);
        }
        return string.compareToIgnoreCase(string2);
    }

    public final boolean checkEquals(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        if (this.sensitive) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public final boolean checkStartsWith(String string, String string2) {
        return string.regionMatches(!this.sensitive, 0, string2, 0, string2.length());
    }

    public final boolean checkEndsWith(String string, String string2) {
        int n2 = string2.length();
        return string.regionMatches(!this.sensitive, string.length() - n2, string2, 0, n2);
    }

    public final int checkIndexOf(String string, int n2, String string2) {
        int n3 = string.length() - string2.length();
        if (n3 >= n2) {
            while (n2 <= n3) {
                if (this.checkRegionMatches(string, n2, string2)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public final boolean checkRegionMatches(String string, int n2, String string2) {
        return string.regionMatches(!this.sensitive, n2, string2, 0, string2.length());
    }

    public final String toString() {
        return this.name;
    }
}

