/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileCleaningTracker$Reaper;
import org.apache.commons.io.FileCleaningTracker$Tracker;
import org.apache.commons.io.FileDeleteStrategy;

public class FileCleaningTracker {
    ReferenceQueue<Object> a = new ReferenceQueue();
    final Collection<FileCleaningTracker$Tracker> b = Collections.synchronizedSet(new HashSet());
    final List<String> c = Collections.synchronizedList(new ArrayList());
    volatile boolean d = false;
    private Thread reaper;

    public void track(File file, Object object) {
        this.track(file, object, null);
    }

    public void track(File file, Object object, FileDeleteStrategy fileDeleteStrategy) {
        if (file == null) {
            throw new NullPointerException("The file must not be null");
        }
        this.addTracker(file.getPath(), object, fileDeleteStrategy);
    }

    public void track(String string, Object object) {
        this.track(string, object, null);
    }

    public void track(String string, Object object, FileDeleteStrategy fileDeleteStrategy) {
        if (string == null) {
            throw new NullPointerException("The path must not be null");
        }
        this.addTracker(string, object, fileDeleteStrategy);
    }

    private synchronized void addTracker(String string, Object object, FileDeleteStrategy fileDeleteStrategy) {
        if (this.d) {
            throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
        }
        if (this.reaper == null) {
            this.reaper = new FileCleaningTracker$Reaper(this);
            this.reaper.start();
        }
        this.b.add(new FileCleaningTracker$Tracker(string, fileDeleteStrategy, object, this.a));
    }

    public int getTrackCount() {
        return this.b.size();
    }

    public List<String> getDeleteFailures() {
        return this.c;
    }

    public synchronized void exitWhenFinished() {
        this.d = true;
        if (this.reaper != null) {
            Thread thread = this.reaper;
            synchronized (thread) {
                this.reaper.interrupt();
                return;
            }
        }
    }
}

