/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library$1;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Rule$Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class Library {
    private static final String LIBRARY_DOWNLOAD_BASE = "https://s3.amazonaws.com/Minecraft.Download/libraries/";
    private static final StrSubstitutor SUBSTITUTOR = new StrSubstitutor(new Library$1());
    private String name;
    private List<Rule> rules;
    private Map<OperatingSystem, String> natives;
    private ExtractRules extract;
    private String url;

    public Library() {
    }

    public Library(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Library name cannot be null or empty");
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Library addNative(OperatingSystem operatingSystem, String string) {
        if (operatingSystem == null || !operatingSystem.isSupported()) {
            throw new IllegalArgumentException("Cannot add native for unsupported OS");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Cannot add native for null or empty name");
        }
        if (this.natives == null) {
            this.natives = new EnumMap<OperatingSystem, String>(OperatingSystem.class);
        }
        this.natives.put(operatingSystem, string);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Object object = Rule$Action.DISALLOW;
        for (Object object2 : this.rules) {
            if ((object2 = object2.getAppliedAction()) == null) continue;
            object = object2;
        }
        return object == Rule$Action.ALLOW;
    }

    public Map<OperatingSystem, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public Library setExtractRules(ExtractRules extractRules) {
        this.extract = extractRules;
        return this;
    }

    public String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] stringArray = this.name.split(":", 3);
        return String.format("%s/%s/%s", stringArray[0].replaceAll("\\.", "/"), stringArray[1], stringArray[2]);
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    public String getArtifactPath(String string) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(string));
    }

    public String getArtifactFilename(String string) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] stringArray = this.name.split(":", 3);
        string = String.format("%s-%s%s.jar", stringArray[1], stringArray[2], StringUtils.isEmpty(string) ? "" : "-" + string);
        return SUBSTITUTOR.replace(string);
    }

    public final String toString() {
        return "Library{name='" + this.name + '\'' + ", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + '}';
    }

    public boolean hasCustomUrl() {
        return this.url != null;
    }

    public String getDownloadUrl() {
        if (this.url != null) {
            return this.url;
        }
        return LIBRARY_DOWNLOAD_BASE;
    }
}

