/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launcher.OperatingSystem;
import net.minecraft.launcher.updater.download.Downloadable;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Rule;
import net.minecraft.launcher.versions.Rule$Action;
import net.minecraft.launcher.versions.Version;

public class CompleteVersion
implements Version {
    private String id;
    private Date time;
    private Date releaseTime;
    private ReleaseType type;
    private String minecraftArguments;
    private List<Library> libraries;
    private String mainClass;
    private int minimumLauncherVersion;
    private String incompatibilityReason;
    private List<Rule> rules;

    public CompleteVersion() {
    }

    public CompleteVersion(String string, Date date, Date date2, ReleaseType releaseType, String string2, String string3) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("ID cannot be null or empty");
        }
        if (date == null) {
            throw new IllegalArgumentException("Release time cannot be null");
        }
        if (date2 == null) {
            throw new IllegalArgumentException("Update time cannot be null");
        }
        if (releaseType == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Main class cannot be null or empty");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Process arguments cannot be null or empty");
        }
        this.id = string;
        this.releaseTime = date;
        this.time = date2;
        this.type = releaseType;
        this.mainClass = string2;
        this.libraries = new ArrayList<Library>();
        this.minecraftArguments = string3;
    }

    public CompleteVersion(CompleteVersion completeVersion) {
        this(completeVersion.getId(), completeVersion.getReleaseTime(), completeVersion.getUpdatedTime(), completeVersion.getType(), completeVersion.getMainClass(), completeVersion.getMinecraftArguments());
    }

    public CompleteVersion(Version version, String string, String string2) {
        this(version.getId(), version.getReleaseTime(), version.getUpdatedTime(), version.getType(), string, string2);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReleaseType getType() {
        return this.type;
    }

    @Override
    public Date getUpdatedTime() {
        return this.time;
    }

    @Override
    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public Collection<Library> getLibraries() {
        return this.libraries;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setUpdatedTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.time = date;
    }

    @Override
    public void setReleaseTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Time cannot be null");
        }
        this.releaseTime = date;
    }

    @Override
    public void setType(ReleaseType releaseType) {
        if (releaseType == null) {
            throw new IllegalArgumentException("Release type cannot be null");
        }
        this.type = releaseType;
    }

    public void setMainClass(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Main class cannot be null or empty");
        }
        this.mainClass = string;
    }

    public Collection<Library> getRelevantLibraries() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (Library library : this.libraries) {
            if (!library.appliesToCurrentEnvironment()) continue;
            arrayList.add(library);
        }
        return arrayList;
    }

    public Collection<File> getClassPath(OperatingSystem object, File file) {
        object = this.getRelevantLibraries();
        ArrayList<File> arrayList = new ArrayList<File>();
        object = object.iterator();
        while (object.hasNext()) {
            Library library = (Library)object.next();
            if (library.getNatives() != null) continue;
            arrayList.add(new File(file, "libraries/" + library.getArtifactPath()));
        }
        arrayList.add(new File(file, "versions/" + this.getId() + "/" + this.getId() + ".jar"));
        return arrayList;
    }

    public Collection<String> getExtractFiles(OperatingSystem operatingSystem) {
        Object object = this.getRelevantLibraries();
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            Library library = (Library)object.next();
            Map<OperatingSystem, String> map = library.getNatives();
            if (map == null || !map.containsKey((Object)operatingSystem)) continue;
            arrayList.add("libraries/" + library.getArtifactPath(map.get((Object)operatingSystem)));
        }
        return arrayList;
    }

    public Set<String> getRequiredFiles(OperatingSystem operatingSystem) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Library library : this.getRelevantLibraries()) {
            if (library.getNatives() != null) {
                String string = library.getNatives().get((Object)operatingSystem);
                if (string == null) continue;
                hashSet.add("libraries/" + library.getArtifactPath(string));
                continue;
            }
            hashSet.add("libraries/" + library.getArtifactPath());
        }
        return hashSet;
    }

    public Set<Downloadable> getRequiredDownloadables(OperatingSystem operatingSystem, Proxy proxy, File file, boolean bl) {
        HashSet<Downloadable> hashSet = new HashSet<Downloadable>();
        for (Library library : this.getRelevantLibraries()) {
            Object object;
            String string = null;
            if (library.getNatives() != null) {
                object = library.getNatives().get((Object)operatingSystem);
                if (object != null) {
                    string = library.getArtifactPath((String)object);
                }
            } else {
                string = library.getArtifactPath();
            }
            if (string == null) continue;
            object = new URL(library.getDownloadUrl() + string);
            File file2 = new File(file, "libraries/" + string);
            if (file2.isFile()) continue;
            hashSet.add(new Downloadable(proxy, (URL)object, file2, bl));
        }
        return hashSet;
    }

    public final String toString() {
        return "CompleteVersion{id='" + this.id + '\'' + ", time=" + this.time + ", type=" + (Object)((Object)this.type) + ", libraries=" + this.libraries + ", mainClass='" + this.mainClass + '\'' + ", minimumLauncherVersion=" + this.minimumLauncherVersion + '}';
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Process arguments cannot be null or empty");
        }
        this.minecraftArguments = string;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public void setMinimumLauncherVersion(int n2) {
        this.minimumLauncherVersion = n2;
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Object object = Rule$Action.DISALLOW;
        for (Object object2 : this.rules) {
            if ((object2 = object2.getAppliedAction()) == null) continue;
            object = object2;
        }
        return object == Rule$Action.ALLOW;
    }

    public String getIncompatibilityReason() {
        return this.incompatibilityReason;
    }
}

