/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater.download;

import java.io.FilterInputStream;
import java.io.InputStream;
import net.minecraft.launcher.updater.download.ProgressContainer;

public class MonitoringInputStream
extends FilterInputStream {
    private final ProgressContainer monitor;

    protected MonitoringInputStream(InputStream inputStream, ProgressContainer progressContainer) {
        super(inputStream);
        this.monitor = progressContainer;
    }

    @Override
    public int read() {
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.monitor.addProgress(1L);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) {
        int n2 = this.in.read(byArray);
        if (n2 >= 0) {
            this.monitor.addProgress(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 > 0) {
            this.monitor.addProgress(n4);
        }
        return n4;
    }

    @Override
    public long skip(long l2) {
        long l3 = super.skip(l2);
        if (l3 > 0L) {
            this.monitor.addProgress(l3);
        }
        return l3;
    }
}

