/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater.download;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.minecraft.launcher.updater.download.MonitoringInputStream;
import net.minecraft.launcher.updater.download.ProgressContainer;

public class Downloadable {
    private final URL url;
    private final File target;
    private final boolean forceDownload;
    private final Proxy proxy;
    private final ProgressContainer monitor;
    private int numAttempts;
    private long expectedSize;

    public Downloadable(Proxy proxy, URL uRL, File file, boolean bl) {
        this.proxy = proxy;
        this.url = uRL;
        this.target = file;
        this.forceDownload = bl;
        this.monitor = new ProgressContainer();
    }

    public ProgressContainer getMonitor() {
        return this.monitor;
    }

    public long getExpectedSize() {
        return this.expectedSize;
    }

    public void setExpectedSize(long l2) {
        this.expectedSize = l2;
    }

    public String download() {
        Object object = null;
        ++this.numAttempts;
        if (this.target.getParentFile() != null && !this.target.getParentFile().isDirectory()) {
            this.target.getParentFile().mkdirs();
        }
        if (!this.forceDownload && this.target.isFile()) {
            object = Downloadable.getMD5(this.target);
        }
        if (this.target.isFile() && !this.target.canWrite()) {
            throw new RuntimeException("Do not have write permissions for " + this.target + " - aborting!");
        }
        try {
            object = this.makeConnection((String)object);
            int n2 = ((HttpURLConnection)object).getResponseCode();
            if (n2 == 304) {
                return "Used own copy as it matched etag";
            }
            if (n2 / 100 == 2) {
                if (this.expectedSize == 0L) {
                    this.monitor.setTotal(((URLConnection)object).getContentLength());
                } else {
                    this.monitor.setTotal(this.expectedSize);
                }
                Object object2 = new MonitoringInputStream(((URLConnection)object).getInputStream(), this.monitor);
                FileOutputStream fileOutputStream = new FileOutputStream(this.target);
                object2 = Downloadable.copyAndDigest((InputStream)object2, fileOutputStream);
                object = Downloadable.getEtag((HttpURLConnection)object);
                if (((String)object).contains("-")) {
                    return "Didn't have etag so assuming our copy is good";
                }
                if (((String)object).equalsIgnoreCase((String)object2)) {
                    return "Downloaded successfully and etag matched";
                }
                throw new RuntimeException(String.format("E-tag did not match downloaded MD5 (ETag was %s, downloaded %s)", object, object2));
            }
            if (this.target.isFile()) {
                return "Couldn't connect to server (responded with " + n2 + ") but have local file, assuming it's good";
            }
            throw new RuntimeException("Server responded with " + n2);
        }
        catch (IOException iOException) {
            if (this.target.isFile()) {
                return "Couldn't connect to server (" + iOException.getClass().getSimpleName() + ": '" + iOException.getMessage() + "') but have local file, assuming it's good";
            }
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Missing Digest.MD5", noSuchAlgorithmException);
        }
    }

    protected HttpURLConnection makeConnection(String string) {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection(this.proxy);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        httpURLConnection.setRequestProperty("Expires", "0");
        httpURLConnection.setRequestProperty("Pragma", "no-cache");
        if (string != null) {
            httpURLConnection.setRequestProperty("If-None-Match", string);
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getTarget() {
        return this.target;
    }

    public boolean shouldIgnoreLocal() {
        return this.forceDownload;
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public static String getMD5(File object) {
        DigestInputStream digestInputStream = null;
        try {
            digestInputStream = new DigestInputStream(new FileInputStream((File)object), MessageDigest.getInstance("MD5"));
            object = new byte[65536];
            int n2 = digestInputStream.read((byte[])object);
            while (n2 > 0) {
                n2 = digestInputStream.read((byte[])object);
            }
        }
        catch (Exception exception) {
            Downloadable.closeSilently(digestInputStream);
            return null;
        }
        catch (Throwable throwable) {
            Downloadable.closeSilently(digestInputStream);
            throw throwable;
        }
        Downloadable.closeSilently(digestInputStream);
        return String.format("%1$032x", new BigInteger(1, digestInputStream.getMessageDigest().digest()));
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyAndDigest(InputStream inputStream, OutputStream outputStream) {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[65536];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                messageDigest.update(byArray, 0, n2);
                outputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        finally {
            Downloadable.closeSilently(inputStream);
            Downloadable.closeSilently(outputStream);
        }
        return String.format("%1$032x", new BigInteger(1, messageDigest.digest()));
    }

    public static String getEtag(HttpURLConnection httpURLConnection) {
        return Downloadable.getEtag(httpURLConnection.getHeaderField("ETag"));
    }

    public static String getEtag(String string) {
        if (string == null) {
            string = "-";
        } else if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }
}

